/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.action;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.action.LDNAction;
import org.dspace.app.ldn.action.LDNActionStatus;
import org.dspace.app.ldn.model.Notification;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class LDNEmailAction
implements LDNAction {
    private static final Logger log = LogManager.getLogger(LDNEmailAction.class);
    private static final String DATE_PATTERN = "dd-MM-yyyy HH:mm:ss";
    @Autowired
    private ConfigurationService configurationService;
    private String actionSendFilter;
    private String actionSendEmailTextFile;

    @Override
    public LDNActionStatus execute(Context context, Notification notification, Item item) throws Exception {
        try {
            Locale supportedLocale = I18nUtil.getEPersonLocale(context.getCurrentUser());
            Email email = Email.getEmail(I18nUtil.getEmailFilename(supportedLocale, this.actionSendEmailTextFile));
            for (String recipient : this.retrieveRecipientsEmail(item)) {
                email.addRecipient(recipient);
            }
            String date = new SimpleDateFormat(DATE_PATTERN).format(Calendar.getInstance().getTime());
            email.addArgument(notification.getActor().getName());
            email.addArgument(item.getName());
            email.addArgument(notification.getActor().getId());
            email.addArgument(notification.getContext() != null ? notification.getContext().getId() : notification.getObject().getId());
            email.addArgument(item.getSubmitter().getFullName());
            email.addArgument(date);
            email.addArgument(notification);
            email.addArgument(item);
            email.send();
        }
        catch (Exception e) {
            log.error("An Error Occurred while sending a notification email", (Throwable)e);
        }
        return LDNActionStatus.CONTINUE;
    }

    public String getActionSendFilter() {
        return this.actionSendFilter;
    }

    public void setActionSendFilter(String actionSendFilter) {
        this.actionSendFilter = actionSendFilter;
    }

    public String getActionSendEmailTextFile() {
        return this.actionSendEmailTextFile;
    }

    public void setActionSendEmailTextFile(String actionSendEmailTextFile) {
        this.actionSendEmailTextFile = actionSendEmailTextFile;
    }

    private List<String> retrieveRecipientsEmail(Item item) {
        List<String> recipients = new LinkedList<String>();
        if (this.actionSendFilter.startsWith("SUBMITTER")) {
            if (item.getSubmitter() != null) {
                recipients.add(item.getSubmitter().getEmail());
            } else {
                recipients.add(this.configurationService.getProperty("ldn.notification.email.submitter.fallback"));
            }
        } else if (this.actionSendFilter.startsWith("GROUP:")) {
            String groupName = this.actionSendFilter.replace("GROUP:", "");
            String property = String.format("email.%s.list", groupName);
            String[] groupEmails = this.configurationService.getArrayProperty(property);
            recipients = Arrays.asList(groupEmails);
        } else {
            recipients.add(this.actionSendFilter);
        }
        return recipients;
    }
}

