/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.lang.reflect.Field;
import java.util.Date;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ReloadableEntity;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

@Entity
@Table(name="ldn_message")
public class LDNMessageEntity
implements ReloadableEntity<String> {
    public static final String TYPE_INCOMING = "Incoming";
    public static final String TYPE_OUTGOING = "Outgoing";
    public static final Integer QUEUE_STATUS_UNTRUSTED_IP = 0;
    public static final Integer QUEUE_STATUS_QUEUED = 1;
    public static final Integer QUEUE_STATUS_PROCESSING = 2;
    public static final Integer QUEUE_STATUS_PROCESSED = 3;
    public static final Integer QUEUE_STATUS_FAILED = 4;
    public static final Integer QUEUE_STATUS_UNTRUSTED = 5;
    public static final Integer QUEUE_STATUS_UNMAPPED_ACTION = 6;
    public static final Integer QUEUE_STATUS_QUEUED_FOR_RETRY = 7;
    @Id
    private String id;
    @ManyToOne
    @JoinColumn(name="object", referencedColumnName="uuid")
    private DSpaceObject object;
    @Column(name="message", columnDefinition="text")
    private String message;
    @Column(name="type")
    private String type;
    @Column(name="queue_status")
    private Integer queueStatus;
    @Column(name="queue_attempts")
    private Integer queueAttempts = 0;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="queue_last_start_time")
    private Date queueLastStartTime = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="queue_timeout")
    private Date queueTimeout = null;
    @ManyToOne
    @JoinColumn(name="origin", referencedColumnName="id")
    private NotifyServiceEntity origin;
    @ManyToOne
    @JoinColumn(name="target", referencedColumnName="id")
    private NotifyServiceEntity target;
    @ManyToOne
    @JoinColumn(name="inReplyTo", referencedColumnName="id")
    private LDNMessageEntity inReplyTo;
    @ManyToOne
    @JoinColumn(name="context", referencedColumnName="uuid")
    private DSpaceObject context;
    @Column(name="activity_stream_type")
    private String activityStreamType;
    @Column(name="coar_notify_type")
    private String coarNotifyType;
    @Column(name="source_ip")
    private String sourceIp;

    protected LDNMessageEntity() {
    }

    public LDNMessageEntity(String id) {
        this.id = id;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DSpaceObject getObject() {
        return this.object;
    }

    public void setObject(DSpaceObject object) {
        this.object = object;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getActivityStreamType() {
        return this.activityStreamType;
    }

    public void setActivityStreamType(String activityStreamType) {
        this.activityStreamType = activityStreamType;
    }

    public String getCoarNotifyType() {
        return this.coarNotifyType;
    }

    public void setCoarNotifyType(String coarNotifyType) {
        this.coarNotifyType = coarNotifyType;
    }

    public NotifyServiceEntity getOrigin() {
        return this.origin;
    }

    public void setOrigin(NotifyServiceEntity origin) {
        this.origin = origin;
    }

    public NotifyServiceEntity getTarget() {
        return this.target;
    }

    public void setTarget(NotifyServiceEntity target) {
        this.target = target;
    }

    public LDNMessageEntity getInReplyTo() {
        return this.inReplyTo;
    }

    public void setInReplyTo(LDNMessageEntity inReplyTo) {
        this.inReplyTo = inReplyTo;
    }

    public DSpaceObject getContext() {
        return this.context;
    }

    public void setContext(DSpaceObject context) {
        this.context = context;
    }

    public Integer getQueueStatus() {
        return this.queueStatus;
    }

    public void setQueueStatus(Integer queueStatus) {
        this.queueStatus = queueStatus;
    }

    public Integer getQueueAttempts() {
        return this.queueAttempts;
    }

    public void setQueueAttempts(Integer queueAttempts) {
        this.queueAttempts = queueAttempts;
    }

    public Date getQueueLastStartTime() {
        return this.queueLastStartTime;
    }

    public void setQueueLastStartTime(Date queueLastStartTime) {
        this.queueLastStartTime = queueLastStartTime;
    }

    public Date getQueueTimeout() {
        return this.queueTimeout;
    }

    public void setQueueTimeout(Date queueTimeout) {
        this.queueTimeout = queueTimeout;
    }

    public String getSourceIp() {
        return this.sourceIp;
    }

    public void setSourceIp(String sourceIp) {
        this.sourceIp = sourceIp;
    }

    public String toString() {
        return "LDNMessage id:" + this.getID() + " typed:" + this.getType();
    }

    public static String getNotificationType(LDNMessageEntity ldnMessage) {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        if (ldnMessage.getOrigin() != null && !ldnMessage.getOrigin().getLdnUrl().contains(configurationService.getProperty("dspace.ui.url"))) {
            return TYPE_INCOMING;
        }
        return TYPE_OUTGOING;
    }

    public static String getServiceNameForNotifyServ(NotifyServiceEntity serviceEntity) {
        if (serviceEntity != null) {
            return serviceEntity.getName();
        }
        return "self";
    }

    public static String getQueueStatus(LDNMessageEntity ldnMessage) {
        Class<LDNMessageEntity> cl = LDNMessageEntity.class;
        try {
            for (Field f : cl.getDeclaredFields()) {
                String fieldName = f.getName();
                if (!fieldName.startsWith("QUEUE_") || f.get(null) != ldnMessage.getQueueStatus()) continue;
                return fieldName;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

