/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.dspace.content.DCDate;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.versioning.DefaultItemVersionProvider;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.dao.VersionDAO;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;
import org.dspace.workflow.WorkflowItemService;
import org.springframework.beans.factory.annotation.Autowired;

public class VersioningServiceImpl
implements VersioningService {
    @Autowired(required=true)
    private VersionHistoryService versionHistoryService;
    @Autowired(required=true)
    protected VersionDAO versionDAO;
    @Autowired(required=true)
    private ItemService itemService;
    @Autowired(required=true)
    private WorkspaceItemService workspaceItemService;
    @Autowired(required=true)
    protected WorkflowItemService workflowItemService;
    private DefaultItemVersionProvider provider;

    @Autowired(required=true)
    public void setProvider(DefaultItemVersionProvider provider) {
        this.provider = provider;
    }

    protected VersioningServiceImpl() {
    }

    @Override
    public Version createNewVersion(Context c, Item item) {
        return this.createNewVersion(c, item, null);
    }

    @Override
    public Version createNewVersion(Context c, Item item, String summary) {
        try {
            VersionHistory vh = this.versionHistoryService.findByItem(c, item);
            if (vh == null) {
                vh = (VersionHistory)this.versionHistoryService.create(c);
                List<MetadataValue> values = this.itemService.getMetadata(item, "dc", "date", "accessioned", "*");
                Date versionDate = new Date();
                if (values != null && values.size() > 0) {
                    String date = values.get(0).getValue();
                    versionDate = new DCDate(date).toDate();
                }
                this.createVersion(c, vh, item, "", versionDate);
            }
            Item itemNew = this.provider.createNewItemAndAddItInWorkspace(c, item);
            Version version = this.createVersion(c, vh, itemNew, summary, new Date());
            this.provider.updateItemState(c, itemNew, item);
            return version;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void delete(Context c, Version version) throws SQLException {
        try {
            Item item = version.getItem();
            VersionHistory history = version.getVersionHistory();
            if (item != null) {
                this.provider.deleteVersionedItem(c, version, history);
            }
            version.setItem(null);
            version.setSummary(null);
            version.setVersionDate(null);
            version.setePerson(null);
            this.versionDAO.save(c, version);
            if (this.getVersionsByHistory(c, history) == null || this.getVersionsByHistory(c, history).isEmpty()) {
                for (Version v : history.getVersions()) {
                    this.versionDAO.delete(c, v);
                }
                this.versionHistoryService.delete(c, history);
            }
            if (item != null) {
                if (!item.isArchived()) {
                    WorkspaceItem wsi = this.workspaceItemService.findByItem(c, item);
                    if (wsi != null) {
                        this.workspaceItemService.deleteAll(c, wsi);
                    } else {
                        Object wfi = this.workflowItemService.findByItem(c, item);
                        if (wfi != null) {
                            this.workflowItemService.delete(c, wfi);
                        }
                    }
                } else {
                    this.itemService.delete(c, item);
                }
            }
        }
        catch (Exception e) {
            c.abort();
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void removeVersion(Context c, Item item) throws SQLException {
        Version version = this.versionDAO.findByItem(c, item);
        if (version != null) {
            this.delete(c, version);
        }
    }

    @Override
    public Version getVersion(Context c, int versionID) throws SQLException {
        return (Version)this.versionDAO.findByID(c, Version.class, versionID);
    }

    @Override
    public Version restoreVersion(Context c, Version version) {
        return this.restoreVersion(c, version, null);
    }

    @Override
    public Version restoreVersion(Context c, Version version, String summary) {
        return null;
    }

    @Override
    public Version updateVersion(Context c, Item item, String summary) throws SQLException {
        Version version = this.versionDAO.findByItem(c, item);
        version.setSummary(summary);
        this.versionDAO.save(c, version);
        return version;
    }

    @Override
    public Version getVersion(Context c, Item item) throws SQLException {
        return this.versionDAO.findByItem(c, item);
    }

    @Override
    public Version createNewVersion(Context context, VersionHistory history, Item item, String summary, Date date, int versionNumber) {
        try {
            Version version = this.versionDAO.create(context, new Version());
            if (versionNumber > 0 && !this.isVersionExist(context, item, versionNumber)) {
                version.setVersionNumber(versionNumber);
            } else {
                version.setVersionNumber(this.getNextVersionNumer(context, history));
            }
            version.setVersionDate(date);
            version.setePerson(item.getSubmitter());
            version.setItem(item);
            version.setSummary(summary);
            version.setVersionHistory(history);
            this.versionDAO.save(context, version);
            this.versionHistoryService.add(context, history, version);
            return version;
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private boolean isVersionExist(Context context, Item item, int versionNumber) throws SQLException {
        VersionHistory history = this.versionHistoryService.findByItem(context, item);
        if (Objects.isNull(history)) {
            return false;
        }
        return history.getVersions().stream().filter(v -> v.getVersionNumber() == versionNumber).findFirst().isPresent();
    }

    @Override
    public List<Version> getVersionsByHistory(Context c, VersionHistory vh) throws SQLException {
        List<Version> versions = this.versionDAO.findVersionsWithItems(c, vh, -1, -1);
        return versions;
    }

    @Override
    public List<Version> getVersionsByHistoryWithItems(Context c, VersionHistory vh, int offset, int limit) throws SQLException {
        return this.versionDAO.findVersionsWithItems(c, vh, offset, limit);
    }

    protected Version createVersion(Context c, VersionHistory vh, Item item, String summary, Date date) throws SQLException {
        return this.createNewVersion(c, vh, item, summary, date, this.getNextVersionNumer(c, vh));
    }

    protected int getNextVersionNumer(Context c, VersionHistory vh) throws SQLException {
        int next = this.versionDAO.getNextVersionNumber(c, vh);
        if (this.versionHistoryService.getLatestVersion(c, vh) != null && this.versionHistoryService.getLatestVersion(c, vh).getVersionNumber() >= next) {
            next = this.versionHistoryService.getLatestVersion(c, vh).getVersionNumber() + 1;
        }
        return next;
    }

    @Override
    public void update(Context context, Version version) throws SQLException {
        this.versionDAO.save(context, version);
    }

    @Override
    public int countVersionsByHistoryWithItem(Context context, VersionHistory versionHistory) throws SQLException {
        return this.versionDAO.countVersionsByHistoryWithItem(context, versionHistory);
    }
}

