/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.versioning;

import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.EntityType;
import org.dspace.content.Item;
import org.dspace.content.Relationship;
import org.dspace.content.RelationshipType;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.EntityTypeService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.RelationshipService;
import org.dspace.content.service.RelationshipTypeService;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.orcid.OrcidHistory;
import org.dspace.orcid.OrcidQueue;
import org.dspace.orcid.factory.OrcidServiceFactory;
import org.dspace.orcid.service.OrcidHistoryService;
import org.dspace.orcid.service.OrcidQueueService;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.utils.RelationshipVersioningUtils;

public class VersioningConsumer
implements Consumer {
    private static final Logger log = LogManager.getLogger(VersioningConsumer.class);
    private Set<Item> itemsToProcess;
    private VersionHistoryService versionHistoryService;
    private ItemService itemService;
    private EntityTypeService entityTypeService;
    private RelationshipTypeService relationshipTypeService;
    private RelationshipService relationshipService;
    private RelationshipVersioningUtils relationshipVersioningUtils;
    private OrcidQueueService orcidQueueService;
    private OrcidHistoryService orcidHistoryService;

    @Override
    public void initialize() throws Exception {
        this.versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
        this.itemService = ContentServiceFactory.getInstance().getItemService();
        this.entityTypeService = ContentServiceFactory.getInstance().getEntityTypeService();
        this.relationshipTypeService = ContentServiceFactory.getInstance().getRelationshipTypeService();
        this.relationshipService = ContentServiceFactory.getInstance().getRelationshipService();
        this.relationshipVersioningUtils = VersionServiceFactory.getInstance().getRelationshipVersioningUtils();
        this.orcidQueueService = OrcidServiceFactory.getInstance().getOrcidQueueService();
        this.orcidHistoryService = OrcidServiceFactory.getInstance().getOrcidHistoryService();
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        if (this.itemsToProcess == null) {
            this.itemsToProcess = new HashSet<Item>();
        }
        if (event.getSubjectType() != 2) {
            return;
        }
        if (event.getEventType() != 64) {
            return;
        }
        Item item = (Item)event.getSubject(ctx);
        if (item == null || !item.isArchived()) {
            return;
        }
        VersionHistory history = this.versionHistoryService.findByItem(ctx, item);
        if (history == null) {
            return;
        }
        Version latestVersion = this.versionHistoryService.getLatestVersion(ctx, history);
        if (latestVersion == null) {
            return;
        }
        Version previousVersion = this.versionHistoryService.getPrevious(ctx, history, latestVersion);
        if (previousVersion == null) {
            return;
        }
        Item latestItem = latestVersion.getItem();
        if (latestItem == null) {
            String msg = String.format("Illegal state: Obtained version history of item with uuid %s, handle %s, but the latest item is null", item.getID(), item.getHandle());
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        Item previousItem = previousVersion.getItem();
        if (previousItem == null) {
            return;
        }
        this.unarchiveItem(ctx, previousItem);
        this.handleOrcidSynchronization(ctx, previousItem, latestItem);
        this.updateRelationships(ctx, latestItem, previousItem);
    }

    protected void unarchiveItem(Context ctx, Item item) {
        item.setArchived(false);
        this.itemsToProcess.add(item);
        ctx.addEvent(new Event(2, item.getType(), item.getID(), null, this.itemService.getIdentifiers(ctx, item)));
    }

    private void handleOrcidSynchronization(Context ctx, Item previousItem, Item latestItem) {
        try {
            this.replaceOrcidHistoryEntities(ctx, previousItem, latestItem);
            this.removeOrcidQueueEntries(ctx, previousItem);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void removeOrcidQueueEntries(Context ctx, Item previousItem) throws SQLException {
        List<OrcidQueue> queueEntries = this.orcidQueueService.findByEntity(ctx, previousItem);
        for (OrcidQueue queueEntry : queueEntries) {
            this.orcidQueueService.delete(ctx, queueEntry);
        }
    }

    private void replaceOrcidHistoryEntities(Context ctx, Item previousItem, Item latestItem) throws SQLException {
        List<OrcidHistory> entries = this.orcidHistoryService.findByEntity(ctx, previousItem);
        for (OrcidHistory entry : entries) {
            entry.setEntity(latestItem);
        }
    }

    protected void updateRelationships(Context ctx, Item latestItem, Item previousItem) {
        if (!this.doEntityTypesMatch(latestItem, previousItem)) {
            return;
        }
        EntityType entityType = this.getEntityType(ctx, latestItem);
        if (entityType == null) {
            return;
        }
        List<RelationshipType> relationshipTypes = this.getRelationshipTypes(ctx, entityType);
        if (CollectionUtils.isEmpty(relationshipTypes)) {
            return;
        }
        for (RelationshipType relationshipType : relationshipTypes) {
            List<Relationship> previousItemRelationships;
            List<Relationship> latestItemRelationships = this.getAllRelationships(ctx, latestItem, relationshipType);
            if (latestItemRelationships == null || (previousItemRelationships = this.getAllRelationships(ctx, previousItem, relationshipType)) == null) continue;
            for (Relationship previousItemRelationship : previousItemRelationships) {
                RelationshipVersioningUtils.LatestVersionStatusChangelog changelog;
                boolean isRight;
                boolean isLeft = previousItem.equals(previousItemRelationship.getLeftItem());
                if (isLeft == (isRight = previousItem.equals(previousItemRelationship.getRightItem()))) {
                    Item leftItem = previousItemRelationship.getLeftItem();
                    Item rightItem = previousItemRelationship.getRightItem();
                    String msg = String.format("Illegal state: could not determine side of item with uuid %s, handle %s in relationship with id %s, rightward name %s between left item with uuid %s, handle %s and right item with uuid %s, handle %s", previousItem.getID(), previousItem.getHandle(), previousItemRelationship.getID(), previousItemRelationship.getRelationshipType().getRightwardType(), leftItem.getID(), leftItem.getHandle(), rightItem.getID(), rightItem.getHandle());
                    log.error(msg);
                    throw new IllegalStateException(msg);
                }
                Relationship latestItemRelationship = this.getMatchingRelationship(latestItem, isLeft, previousItemRelationship, latestItemRelationships);
                if (this.relationshipVersioningUtils.otherSideIsLatest(isLeft, previousItemRelationship.getLatestVersionStatus())) {
                    changelog = this.relationshipVersioningUtils.updateLatestVersionStatus(previousItemRelationship, isLeft, false);
                    this.reindexRelationship(ctx, changelog, previousItemRelationship);
                }
                if (latestItemRelationship == null) continue;
                changelog = this.relationshipVersioningUtils.updateLatestVersionStatus(latestItemRelationship, isLeft, true);
                this.reindexRelationship(ctx, changelog, latestItemRelationship);
            }
        }
    }

    protected void reindexRelationship(Context ctx, RelationshipVersioningUtils.LatestVersionStatusChangelog changelog, Relationship relationship) {
        if (changelog == RelationshipVersioningUtils.LatestVersionStatusChangelog.NO_CHANGES) {
            return;
        }
        Item leftItem = relationship.getLeftItem();
        this.itemsToProcess.add(leftItem);
        ctx.addEvent(new Event(2, leftItem.getType(), leftItem.getID(), null, this.itemService.getIdentifiers(ctx, leftItem)));
        Item rightItem = relationship.getRightItem();
        this.itemsToProcess.add(rightItem);
        ctx.addEvent(new Event(2, rightItem.getType(), rightItem.getID(), null, this.itemService.getIdentifiers(ctx, rightItem)));
    }

    protected boolean doEntityTypesMatch(Item latestItem, Item previousItem) {
        String latestItemEntityType = this.itemService.getEntityTypeLabel(latestItem);
        String previousItemEntityType = this.itemService.getEntityTypeLabel(previousItem);
        if (latestItemEntityType == null || previousItemEntityType == null) {
            if (previousItemEntityType != null) {
                log.warn("Inconsistency: Item with uuid {}, handle {} has NO entity type, but the previous version of that item with uuid {}, handle {} has entity type {}", (Object)latestItem.getID(), (Object)latestItem.getHandle(), (Object)previousItem.getID(), (Object)previousItem.getHandle(), (Object)previousItemEntityType);
            }
            return false;
        }
        if (!StringUtils.equals((CharSequence)latestItemEntityType, (CharSequence)previousItemEntityType)) {
            log.warn("Inconsistency: Item with uuid {}, handle {} has entity type {}, but the previous version of that item with uuid {}, handle {} has entity type {}", (Object)latestItem.getID(), (Object)latestItem.getHandle(), (Object)latestItemEntityType, (Object)previousItem.getID(), (Object)previousItem.getHandle(), (Object)previousItemEntityType);
            return false;
        }
        log.info("Item with uuid {}, handle {} and the previous version of that item with uuid {}, handle {} have the same entity type: {}", (Object)latestItem.getID(), (Object)latestItem.getHandle(), (Object)previousItem.getID(), (Object)previousItem.getHandle(), (Object)latestItemEntityType);
        return true;
    }

    protected EntityType getEntityType(Context ctx, Item item) {
        try {
            return this.itemService.getEntityType(ctx, item);
        }
        catch (SQLException e) {
            log.error("Exception occurred when trying to obtain entity type with label {} of item with uuid {}, handle {}", (Object)this.itemService.getEntityTypeLabel(item), (Object)item.getID(), (Object)item.getHandle(), (Object)e);
            return null;
        }
    }

    protected List<RelationshipType> getRelationshipTypes(Context ctx, EntityType entityType) {
        try {
            return this.relationshipTypeService.findByEntityType(ctx, entityType);
        }
        catch (SQLException e) {
            log.error("Exception occurred when trying to obtain relationship types via entity type with id {}, label {}", (Object)entityType.getID(), (Object)entityType.getLabel(), (Object)e);
            return null;
        }
    }

    protected List<Relationship> getAllRelationships(Context ctx, Item item, RelationshipType relationshipType) {
        try {
            return this.relationshipService.findByItemAndRelationshipType(ctx, item, relationshipType, -1, -1, false);
        }
        catch (SQLException e) {
            log.error("Exception occurred when trying to obtain relationships of type with id {}, rightward name {} for item with uuid {}, handle {}", (Object)relationshipType.getID(), (Object)relationshipType.getRightwardType(), (Object)item.getID(), (Object)item.getHandle(), (Object)e);
            return null;
        }
    }

    protected Relationship getMatchingRelationship(Item latestItem, boolean isLeft, Relationship previousItemRelationship, List<Relationship> relationships) {
        Item leftItem = previousItemRelationship.getLeftItem();
        RelationshipType relationshipType = previousItemRelationship.getRelationshipType();
        Item rightItem = previousItemRelationship.getRightItem();
        if (isLeft) {
            return this.getMatchingRelationship(latestItem, relationshipType, rightItem, relationships);
        }
        return this.getMatchingRelationship(leftItem, relationshipType, latestItem, relationships);
    }

    protected Relationship getMatchingRelationship(Item expectedLeftItem, RelationshipType expectedRelationshipType, Item expectedRightItem, List<Relationship> relationships) {
        Integer expectedRelationshipTypeId = expectedRelationshipType.getID();
        List matchingRelationships = relationships.stream().filter(relationship -> {
            int relationshipTypeId = relationship.getRelationshipType().getID();
            boolean leftItemMatches = expectedLeftItem.equals(relationship.getLeftItem());
            boolean relationshipTypeMatches = expectedRelationshipTypeId == relationshipTypeId;
            boolean rightItemMatches = expectedRightItem.equals(relationship.getRightItem());
            return leftItemMatches && relationshipTypeMatches && rightItemMatches;
        }).distinct().collect(Collectors.toUnmodifiableList());
        if (matchingRelationships.isEmpty()) {
            return null;
        }
        if (matchingRelationships.size() > 1) {
            String msg = String.format("Illegal state: expected 0 or 1 relationship, but found %s relationships (ids: %s) of type with id %s, rightward name %s between left item with uuid %s, handle %s and right item with uuid %s, handle %s", matchingRelationships.size(), matchingRelationships.stream().map(Relationship::getID).collect(Collectors.toUnmodifiableList()), expectedRelationshipTypeId, expectedRelationshipType.getRightwardType(), expectedLeftItem.getID(), expectedLeftItem.getHandle(), expectedRightItem.getID(), expectedRightItem.getHandle());
            log.error(msg);
            throw new IllegalStateException(msg);
        }
        return (Relationship)matchingRelationships.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Context ctx) throws Exception {
        if (this.itemsToProcess != null) {
            for (Item item : this.itemsToProcess) {
                ctx.turnOffAuthorisationSystem();
                try {
                    this.itemService.update(ctx, item);
                }
                finally {
                    ctx.restoreAuthSystemState();
                }
            }
        }
        this.itemsToProcess = null;
    }
}

