/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.util;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.FacetField;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.SolrParams;
import org.dspace.content.Bitstream;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;
import org.dspace.eperson.service.GroupService;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class SolrUpgradePre6xStatistics {
    private static final String INDEX_NAME_OPTION = "i";
    private static final String NUMREC_OPTION = "n";
    private static final String BATCH_OPTION = "b";
    private static final String TYPE_OPTION = "t";
    private static final String HELP_OPTION = "h";
    private static final int NUMREC_DEFAULT = 100000;
    private static final int BATCH_DEFAULT = 10000;
    private static final int CACHE_LIMIT = 20000;
    private static final String INDEX_DEFAULT = "statistics";
    private static final String MIGQUERY = "(id:* AND -(id:*-*)) OR (scopeId:* AND -(scopeId:*-*)) OR (epersonid:* AND -(epersonid:*-*))";
    private int numRec = 100000;
    private int batchSize = 10000;
    private int numProcessed = 0;
    private long totalCache = 0L;
    private long numUncache = 0L;
    private final List<SolrInputDocument> docs = new ArrayList<SolrInputDocument>();
    private Context context;
    private static final Logger log = LogManager.getLogger();
    private ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
    protected CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    protected CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    protected ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    protected BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    protected EPersonService epersonService = EPersonServiceFactory.getInstance().getEPersonService();
    protected GroupService groupService = EPersonServiceFactory.getInstance().getGroupService();
    private final HttpSolrClient server;
    private Item lastItem = null;
    private Bitstream lastBitstream = null;
    private long startTime = -1L;
    private long lastTime = -1L;

    public SolrUpgradePre6xStatistics(String indexName, int numRec, int batchSize) throws SolrServerException, IOException {
        String serverPath = this.configurationService.getProperty("solr-statistics.server");
        serverPath = serverPath.replaceAll("statistics$", indexName);
        System.out.println("Connecting to " + serverPath);
        this.server = new HttpSolrClient.Builder(serverPath).build();
        this.numRec = numRec;
        this.batchSize = batchSize;
        this.refreshContext();
    }

    private void batchUpdateStats() throws SolrServerException, IOException {
        if (this.docs.size() > 0) {
            this.server.add(this.docs);
            this.server.commit(true, true);
            this.docs.clear();
        }
    }

    private void refreshContext() throws SolrServerException, IOException {
        if (this.context != null) {
            try {
                this.totalCache += this.numUncache + this.context.getCacheSize();
            }
            catch (SQLException e) {
                log.warn(e.getMessage());
            }
        }
        this.context = new Context(Context.Mode.READ_ONLY);
        this.lastItem = null;
        this.lastBitstream = null;
        this.numUncache = 0L;
    }

    private long getCacheCounts(boolean fromStart) {
        long count = 0L;
        try {
            count = this.context.getCacheSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        count += this.numUncache;
        if (fromStart) {
            count += this.totalCache;
        }
        return count;
    }

    private long logTime(boolean fromStart) {
        long ret = 0L;
        long cur = new Date().getTime();
        if (this.lastTime == -1L) {
            this.startTime = cur;
        } else {
            ret = fromStart ? cur - this.startTime : cur - this.lastTime;
        }
        this.lastTime = cur;
        return ret;
    }

    private String duration(long dur) {
        long sec = dur / 1000L;
        long hh = sec / 3600L;
        long mm = sec % 3600L / 60L;
        long ss = sec % 60L;
        return String.format("%d:%02d:%02d", hh, mm, ss);
    }

    private void printTime(int numProcessed, boolean fromStart) {
        long dur = this.logTime(fromStart);
        long totalDur = this.logTime(true);
        String stotalDur = this.duration(totalDur);
        long cacheSize = 0L;
        try {
            cacheSize = this.context.getCacheSize();
        }
        catch (SQLException e) {
            log.error("Cannot get cache size", (Throwable)e);
        }
        String label = fromStart ? "TOTAL" : "Processed";
        System.out.println(String.format("%s (%s; %s; %s)", String.format("\t%,12d %10s...", numProcessed, label), String.format("%,6d sec; %s", dur / 1000L, stotalDur), String.format("DB cache: %,6d/%,8d", cacheSize, this.getCacheCounts(fromStart)), String.format("Docs: %,6d", this.docs.size())));
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption(HELP_OPTION, "help", false, "Get help on options for this command.");
        options.addOption(INDEX_NAME_OPTION, "index-name", true, "The names of the indexes to process. At least one is required (default=statistics)");
        options.addOption(NUMREC_OPTION, "num-rec", true, "Total number of records to update (defaut=100,000).");
        options.addOption(BATCH_OPTION, "batch-size", true, "Number of records to batch update to SOLR at one time (default=10,000).");
        return options;
    }

    private static void printHelpAndExit(Options options, int exitCode) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp(SolrUpgradePre6xStatistics.class.getSimpleName() + "\n", options);
        System.out.println("\n\nCommand Defaults");
        System.out.println("\tsolr-upgrade-statistics-6x [-i statistics] [-n num_recs_to_process] [-b num_rec_to_update_at_once]");
        System.out.println("");
        System.out.println("\tAfter upgrading to DSpace 6, this process should be run iteratively over every statistics shard ");
        System.out.println("\t\tuntil there are no remaining records with legacy ids present.");
        System.out.println("\t\tThis process can be run while the system is in use.");
        System.out.println("");
        System.out.println("\tIt will take 20-30 min to process 1,000,000 legacy records. ");
        System.out.println("");
        System.out.println("\tUse the -n option to manage the workload on your server. ");
        System.out.println("\t\tTo process all records, set -n to 10000000 or to 100000000 (10M or 100M)");
        System.out.println("\tIf possible, please allocate 2GB of memory to this process (e.g. -Xmx2000m)");
        System.out.println("");
        System.out.println("\tThis process will rewrite most solr statistics records and may temporarily double ");
        System.out.println("\t\tthe size of your statistics repositories.  Consider optimizing your solr repos when complete.");
        System.exit(exitCode);
    }

    public static void main(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        Options options = SolrUpgradePre6xStatistics.makeOptions();
        System.out.println(" * This process should be run iteratively over every statistics shard ");
        System.out.println(" * until there are no remaining records with legacy ids present.");
        System.out.println(" * This process can be run while the system is in use.");
        System.out.println(" * It is likely to take 1 hour/1,000,000 legacy records to be udpated.");
        System.out.println(" *");
        System.out.println(" * This process will rewrite most solr statistics records and may temporarily double ");
        System.out.println(" *\tthe size of your statistics repositories.  Consider optimizing your solr repos when complete.");
        System.out.println(" * -------------------------------------------------------------------");
        String indexName = INDEX_DEFAULT;
        int numrec = 100000;
        int batchSize = 10000;
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption(HELP_OPTION)) {
                SolrUpgradePre6xStatistics.printHelpAndExit(options, 0);
            }
            if (line.hasOption(INDEX_NAME_OPTION)) {
                indexName = line.getOptionValue(INDEX_NAME_OPTION, INDEX_DEFAULT);
            } else {
                System.err.println("No index name provided, defaulting to : statistics");
            }
            if (line.hasOption(NUMREC_OPTION)) {
                numrec = Integer.parseInt(line.getOptionValue(NUMREC_OPTION, "100000"));
            }
            if (line.hasOption(BATCH_OPTION)) {
                batchSize = Integer.parseInt(line.getOptionValue(BATCH_OPTION, "10000"));
            }
        }
        catch (ParseException e) {
            System.err.println("Cannot read command options");
            SolrUpgradePre6xStatistics.printHelpAndExit(options, 1);
        }
        try {
            SolrUpgradePre6xStatistics upgradeStats = new SolrUpgradePre6xStatistics(indexName, numrec, batchSize);
            upgradeStats.run();
        }
        catch (IOException | SQLException | SolrServerException e) {
            log.error("Error querying stats", e);
        }
    }

    private void runReport() throws SolrServerException, IOException {
        System.out.println();
        System.out.println("=================================================================");
        System.out.println("\t*** Statistics Records with Legacy Id ***\n");
        long total = this.runReportQuery();
        System.out.println("\t--------------------------------------");
        System.out.println(String.format("\t%,12d\t%s", total, "TOTAL"));
        System.out.println("=================================================================");
        System.out.println();
    }

    private long runReportQuery() throws SolrServerException, IOException {
        long rem;
        SolrQuery sQ = new SolrQuery();
        sQ.setQuery(MIGQUERY);
        sQ.setFacet(true);
        sQ.addFacetField(new String[]{"type"});
        sQ.addFacetField(new String[]{"scopeType"});
        QueryResponse sr = this.server.query((SolrParams)sQ);
        long total = 0L;
        long unexpected = 0L;
        for (FacetField ff : sr.getFacetFields()) {
            String s = ff.getName().equals("type") ? "View" : "Search";
            for (FacetField.Count count : ff.getValues()) {
                Object name = count.getName();
                int id = Integer.parseInt((String)name);
                if (id == 4) {
                    name = "Community " + s;
                } else if (id == 3) {
                    name = "Collection " + s;
                } else if (id == 2) {
                    name = "Item " + s;
                } else if (id == 0) {
                    name = "Bistream " + s;
                } else {
                    unexpected += count.getCount();
                    continue;
                }
                System.out.println(String.format("\t%,12d\t%s", count.getCount(), name));
                total += count.getCount();
            }
        }
        if (unexpected > 0L) {
            System.out.println(String.format("\t%,12d\t%s", unexpected, "Unexpected Type & Full Site"));
            total += unexpected;
        }
        if ((rem = sr.getResults().getNumFound() - total) > 0L) {
            System.out.println(String.format("\t%,12d\t%s", rem, "Other Records"));
            total += rem;
        }
        return total;
    }

    private void run() throws SolrServerException, SQLException, IOException {
        this.runReport();
        this.logTime(false);
        int processed = this.updateRecords(MIGQUERY);
        while (processed != 0 && this.numProcessed <= this.numRec) {
            this.printTime(this.numProcessed, false);
            this.batchUpdateStats();
            if (this.context.getCacheSize() > 20000L) {
                this.refreshContext();
            }
            processed = this.updateRecords(MIGQUERY);
        }
        this.printTime(this.numProcessed, true);
        if (this.numProcessed > 0) {
            this.runReport();
        }
    }

    private int updateRecords(String query) throws SolrServerException, SQLException, IOException {
        int initNumProcessed = this.numProcessed;
        SolrQuery sQ = new SolrQuery();
        sQ.setQuery(query);
        sQ.setRows(Integer.valueOf(this.batchSize));
        sQ.addSort("type", SolrQuery.ORDER.desc);
        sQ.addSort("scopeType", SolrQuery.ORDER.desc);
        sQ.addSort("ord(owningItem)", SolrQuery.ORDER.desc);
        sQ.addSort("ord(id)", SolrQuery.ORDER.asc);
        sQ.addSort("ord(scopeId)", SolrQuery.ORDER.asc);
        QueryResponse sr = this.server.query((SolrParams)sQ);
        SolrDocumentList sdl = sr.getResults();
        for (int i = 0; i < sdl.size() && this.numProcessed < this.numRec; ++i) {
            SolrDocument sd = (SolrDocument)sdl.get(i);
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            for (String name : sd.getFieldNames()) {
                input.addField(name, sd.getFieldValue(name));
            }
            input.remove((Object)"_version_");
            for (FIELD col : FIELD.values()) {
                this.mapField(input, col);
            }
            this.docs.add(input);
            ++this.numProcessed;
        }
        return this.numProcessed - initNumProcessed;
    }

    private void mapField(SolrInputDocument input, FIELD col) throws SQLException {
        SolrInputField ifield = input.get((Object)col.name());
        if (ifield != null) {
            Collection vals = ifield.getValues();
            ArrayList<Object> newvals = new ArrayList<Object>();
            for (Object e : vals) {
                for (String oval : e.toString().split(",")) {
                    oval = oval.replace("\\", "");
                    try {
                        UUID uuid = null;
                        if (col == FIELD.owner) {
                            if (oval.length() > 1) {
                                String owntype = oval.substring(0, 1);
                                int legacy = Integer.parseInt(oval.substring(1));
                                uuid = this.mapOwner(owntype, legacy);
                            }
                        } else {
                            int legacy = Integer.parseInt(oval);
                            if (col == FIELD.id) {
                                Object otype = input.getFieldValue("type");
                                if (otype != null) {
                                    type = Integer.parseInt(otype.toString());
                                    uuid = this.mapType(type, legacy);
                                }
                            } else if (col == FIELD.scopeId) {
                                Object otype = input.getFieldValue("scopeType");
                                if (otype != null) {
                                    type = Integer.parseInt(otype.toString());
                                    uuid = this.mapType(type, legacy);
                                }
                            } else {
                                uuid = this.mapId(col, legacy);
                            }
                        }
                        if (uuid != null) {
                            if (newvals.contains(uuid.toString())) continue;
                            newvals.add(uuid.toString());
                            continue;
                        }
                        String s = oval + "-unmigrated";
                        if (newvals.contains(s)) continue;
                        newvals.add(s);
                    }
                    catch (NumberFormatException e2) {
                        log.warn("Non numeric legacy id " + col.name() + ":" + oval);
                    }
                }
            }
            if (newvals.size() > 0) {
                input.removeField(col.name());
                for (String string : newvals) {
                    input.addField(col.name(), (Object)string);
                }
            }
        }
    }

    private void checkLastItem(Item item) throws SQLException {
        if (item != null) {
            if (this.lastItem == null) {
                this.lastItem = item;
            } else if (!this.lastItem.getID().equals(item.getID())) {
                ++this.numUncache;
                this.context.uncacheEntity(this.lastItem);
                this.lastItem = item;
            }
        }
    }

    private void checkLastBitstream(Bitstream bitstream) throws SQLException {
        if (bitstream != null) {
            if (this.lastBitstream == null) {
                this.lastBitstream = bitstream;
            } else if (!this.lastBitstream.getID().equals(bitstream.getID())) {
                ++this.numUncache;
                this.context.uncacheEntity(this.lastBitstream);
                this.lastBitstream = bitstream;
            }
        }
    }

    private UUID mapId(FIELD col, int val) throws SQLException {
        if (col == FIELD.owningComm) {
            Community comm = (Community)this.communityService.findByLegacyId(this.context, val);
            return comm == null ? null : comm.getID();
        }
        if (col == FIELD.owningColl) {
            org.dspace.content.Collection coll = (org.dspace.content.Collection)this.collectionService.findByLegacyId(this.context, val);
            return coll == null ? null : coll.getID();
        }
        if (col == FIELD.owningItem) {
            Item item = (Item)this.itemService.findByLegacyId(this.context, val);
            this.checkLastItem(item);
            return item == null ? null : item.getID();
        }
        if (col == FIELD.epersonid || col == FIELD.actor || col == FIELD.submitter) {
            EPerson per = (EPerson)this.epersonService.findByLegacyId(this.context, val);
            return per == null ? null : per.getID();
        }
        return null;
    }

    private UUID mapType(int type, int val) throws SQLException {
        if (type == 4) {
            Community comm = (Community)this.communityService.findByLegacyId(this.context, val);
            return comm == null ? null : comm.getID();
        }
        if (type == 3) {
            org.dspace.content.Collection coll = (org.dspace.content.Collection)this.collectionService.findByLegacyId(this.context, val);
            return coll == null ? null : coll.getID();
        }
        if (type == 2) {
            Item item = (Item)this.itemService.findByLegacyId(this.context, val);
            this.checkLastItem(item);
            return item == null ? null : item.getID();
        }
        if (type == 0) {
            Bitstream bit = (Bitstream)this.bitstreamService.findByLegacyId(this.context, val);
            UUID uuid = bit == null ? null : bit.getID();
            this.checkLastBitstream(bit);
            return uuid;
        }
        return null;
    }

    private UUID mapOwner(String owntype, int val) throws SQLException {
        if (owntype.equals("e")) {
            EPerson per = (EPerson)this.epersonService.findByLegacyId(this.context, val);
            return per == null ? null : per.getID();
        }
        if (owntype.equals("g")) {
            Group perg = (Group)this.groupService.findByLegacyId(this.context, val);
            return perg == null ? null : perg.getID();
        }
        return null;
    }

    private static enum FIELD {
        id,
        scopeId,
        owningComm,
        owningColl,
        owningItem,
        epersonid,
        owner,
        submitter,
        actor;

    }
}

