/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.export;

import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.dspace.core.Context;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.statistics.export.RetryFailedOpenUrlTrackerScriptConfiguration;
import org.dspace.statistics.export.factory.OpenURLTrackerLoggerServiceFactory;
import org.dspace.statistics.export.service.OpenUrlService;
import org.dspace.utils.DSpace;

public class RetryFailedOpenUrlTracker
extends DSpaceRunnable<RetryFailedOpenUrlTrackerScriptConfiguration> {
    private String lineToAdd = null;
    private boolean help = false;
    private boolean retryFailed = false;
    private OpenUrlService openUrlService;

    @Override
    public void internalRun() throws Exception {
        if (this.help) {
            this.printHelp();
            return;
        }
        Context context = new Context();
        context.turnOffAuthorisationSystem();
        if (StringUtils.isNotBlank((CharSequence)this.lineToAdd)) {
            this.openUrlService.logfailed(context, this.lineToAdd);
            this.handler.logInfo("Created dummy entry in OpenUrlTracker with URL: " + this.lineToAdd);
        }
        if (this.retryFailed) {
            this.handler.logInfo("Reprocessing failed URLs stored in the db");
            this.openUrlService.reprocessFailedQueue(context);
        }
        context.restoreAuthSystemState();
        context.complete();
    }

    @Override
    public RetryFailedOpenUrlTrackerScriptConfiguration getScriptConfiguration() {
        return (RetryFailedOpenUrlTrackerScriptConfiguration)new DSpace().getServiceManager().getServiceByName("retry-tracker", RetryFailedOpenUrlTrackerScriptConfiguration.class);
    }

    @Override
    public void setup() throws ParseException {
        this.openUrlService = OpenURLTrackerLoggerServiceFactory.getInstance().getOpenUrlService();
        if (!(this.commandLine.hasOption('a') || this.commandLine.hasOption('r') || this.commandLine.hasOption('h'))) {
            throw new ParseException("At least one of the parameters (-a, -r, -h) is required!");
        }
        if (this.commandLine.hasOption('h')) {
            this.help = true;
        }
        if (this.commandLine.hasOption('a')) {
            this.lineToAdd = this.commandLine.getOptionValue('a');
        }
        if (this.commandLine.hasOption('r')) {
            this.retryFailed = true;
        }
    }
}

