/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.statistics.content;

import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrServerException;
import org.dspace.core.Context;
import org.dspace.statistics.Dataset;
import org.dspace.statistics.content.DatasetGenerator;
import org.dspace.statistics.content.StatisticsData;
import org.dspace.statistics.content.filter.StatisticsFilter;

public abstract class StatisticsDisplay {
    private String id;
    private StatisticsData statisticsData;
    private String title;
    private List<String> css;

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    protected StatisticsDisplay(StatisticsData statisticsData) {
        this.statisticsData = statisticsData;
    }

    public List<DatasetGenerator> getDatasetGenerators() {
        return this.statisticsData.getDatasetGenerators();
    }

    public void addDatasetGenerator(DatasetGenerator set) {
        this.statisticsData.addDatasetGenerator(set);
    }

    public void addFilter(StatisticsFilter filter) {
        this.statisticsData.addFilters(filter);
    }

    public List<StatisticsFilter> getFilters() {
        return this.statisticsData.getFilters();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setDataset(Dataset dataset) {
        this.statisticsData.setDataset(dataset);
    }

    public abstract String getType();

    public Dataset getDataset() {
        return this.statisticsData.getDataset();
    }

    public Dataset getDataset(Context context, int facetMinCount) throws SQLException, SolrServerException, IOException, ParseException {
        return this.statisticsData.createDataset(context, facetMinCount);
    }

    public void addCss(String style) {
        if (style != null) {
            if (this.css == null) {
                this.css = new ArrayList<String>();
            }
            this.css.add(style.trim());
        }
    }

    public String getCss() {
        if (this.css != null) {
            StringBuilder result = new StringBuilder();
            for (String s : this.css) {
                result.append(s);
                if (s.endsWith(";")) continue;
                result.append(";");
            }
            return result.toString();
        }
        return "";
    }
}

