/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTP;
import org.apache.jena.sparql.exec.http.QueryExecutionHTTPBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.rdf.storage.RDFStorage;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class RDFStorageImpl
implements RDFStorage {
    private static final Logger log = LogManager.getLogger(RDFStorageImpl.class);
    @Autowired(required=true)
    protected ConfigurationService configurationService;

    @Override
    public void store(String uri, Model model) {
        RDFConnection connection = this.getConnection();
        connection.put(uri, model);
    }

    @Override
    public Model load(String uri) {
        RDFConnection connection = this.getConnection();
        return connection.fetch(uri);
    }

    protected RDFConnection getConnection() {
        if (this.configurationService.hasProperty("rdf.storage.graphstore.login") && this.configurationService.hasProperty("rdf.storage.graphstore.password")) {
            AuthEnv.get().registerUsernamePassword(this.getGraphStoreEndpoint(), this.configurationService.getProperty("rdf.storage.graphstore.login"), this.configurationService.getProperty("rdf.storage.graphstore.password"));
        } else {
            log.debug("Did not found credential to use for our connection to the Graph Store HTTP endpoint, trying to connect unauthenticated.");
        }
        RDFConnection connection = RDFConnectionRemote.service((String)this.getGraphStoreEndpoint()).build();
        return connection;
    }

    @Override
    public void delete(String uri) {
        this.getConnection().delete(uri);
    }

    @Override
    public void deleteAll() {
        for (String graph : this.getAllStoredGraphs()) {
            this.delete(graph);
        }
        this.getConnection().delete();
    }

    @Override
    public List<String> getAllStoredGraphs() {
        String queryString = "SELECT DISTINCT ?g WHERE { GRAPH ?g { ?s ?p ?o } }";
        if (this.configurationService.hasProperty("rdf.storage.sparql.login") && this.configurationService.hasProperty("rdf.storage.sparql.password")) {
            AuthEnv.get().registerUsernamePassword(this.getSparqlEndpoint(), this.configurationService.getProperty("rdf.storage.sparql.login"), this.configurationService.getProperty("rdf.storage.graphstore.password"));
        }
        List<String> graphs = Collections.synchronizedList(new ArrayList());
        try (QueryExecution qexec = (QueryExecution)((QueryExecutionHTTPBuilder)QueryExecutionHTTP.service((String)this.getSparqlEndpoint()).queryString(queryString)).build();){
            ResultSet rs = qexec.execSelect();
            while (rs.hasNext()) {
                QuerySolution solution = rs.next();
                if (!solution.contains("g")) continue;
                graphs.add(solution.get("g").asResource().getURI());
            }
        }
        return graphs;
    }

    protected String getGraphStoreEndpoint() {
        String endpoint = this.configurationService.getProperty("rdf.storage.graphstore.endpoint");
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            log.warn("Cannot load Graph Store HTTP Protocol endpoint! Property rdf.storage.graphstore.endpoint does not exist or is empty.");
            throw new RuntimeException("Cannot load Graph Store HTTP Protocol endpoint! Property rdf.storage.graphstore.endpoint does not exist or is empty.");
        }
        return endpoint;
    }

    protected String getSparqlEndpoint() {
        String endpoint = this.configurationService.getProperty("rdf.storage.sparql.endpoint");
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            endpoint = this.configurationService.getProperty("rdf.public.sparql.endpoint");
        }
        if (StringUtils.isEmpty((CharSequence)endpoint)) {
            log.warn("Cannot load internal or public SPARQL endpoint!");
            throw new RuntimeException("Cannot load internal or public SPARQL endpoint!");
        }
        return endpoint;
    }
}

