/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.storage;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.SiteService;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.handle.service.HandleService;
import org.dspace.rdf.storage.URIGenerator;
import org.springframework.beans.factory.annotation.Autowired;

public class HandleURIGenerator
implements URIGenerator {
    private static final Logger log = LogManager.getLogger(HandleURIGenerator.class);
    @Autowired(required=true)
    protected SiteService siteService;
    @Autowired(required=true)
    protected HandleService handleService;

    @Override
    public String generateIdentifier(Context context, int type, UUID id, String handle, List<String> identifiers) throws SQLException {
        if (type == 5) {
            return this.handleService.getCanonicalForm(this.siteService.findSite(context).getHandle());
        }
        if (type == 4 || type == 3 || type == 2) {
            if (StringUtils.isEmpty((CharSequence)handle)) {
                throw new IllegalArgumentException("Handle is null");
            }
            log.debug("Generated identifier " + this.handleService.getCanonicalForm(handle) + " for " + Constants.typeText[type] + " " + id.toString() + ".");
            return this.handleService.getCanonicalForm(handle);
        }
        return null;
    }

    @Override
    public String generateIdentifier(Context context, DSpaceObject dso) throws SQLException {
        if (dso.getType() != 5 && dso.getType() != 4 && dso.getType() != 3 && dso.getType() != 2) {
            return null;
        }
        return this.generateIdentifier(context, dso.getType(), dso.getID(), dso.getHandle(), ContentServiceFactory.getInstance().getDSpaceObjectService(dso).getIdentifiers(context, dso));
    }
}

