/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.qaevent;

import java.sql.SQLException;
import java.util.UUID;
import org.dspace.content.Item;
import org.dspace.content.QAEvent;
import org.dspace.content.logic.LogicalStatement;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.qaevent.AutomaticProcessingAction;
import org.dspace.qaevent.QAEventAutomaticProcessingEvaluation;
import org.springframework.beans.factory.annotation.Autowired;

public class QAScoreAutomaticProcessingEvaluation
implements QAEventAutomaticProcessingEvaluation {
    private double scoreToApprove;
    private double scoreToIgnore;
    private double scoreToReject;
    private LogicalStatement itemFilterToApprove;
    private LogicalStatement itemFilterToIgnore;
    private LogicalStatement itemFilterToReject;
    @Autowired
    private ItemService itemService;

    @Override
    public AutomaticProcessingAction evaluateAutomaticProcessing(Context context, QAEvent qaEvent) {
        Item item = this.findItem(context, qaEvent.getTarget());
        if (this.shouldReject(context, qaEvent.getTrust(), item)) {
            return AutomaticProcessingAction.REJECT;
        }
        if (this.shouldIgnore(context, qaEvent.getTrust(), item)) {
            return AutomaticProcessingAction.IGNORE;
        }
        if (this.shouldApprove(context, qaEvent.getTrust(), item)) {
            return AutomaticProcessingAction.ACCEPT;
        }
        return null;
    }

    private Item findItem(Context context, String uuid) {
        try {
            return (Item)this.itemService.find(context, UUID.fromString(uuid));
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean shouldReject(Context context, double trust, Item item) {
        return trust <= this.scoreToReject && (this.itemFilterToReject == null || this.itemFilterToReject.getResult(context, item));
    }

    private boolean shouldIgnore(Context context, double trust, Item item) {
        return trust <= this.scoreToIgnore && (this.itemFilterToIgnore == null || this.itemFilterToIgnore.getResult(context, item));
    }

    private boolean shouldApprove(Context context, double trust, Item item) {
        return trust >= this.scoreToApprove && (this.itemFilterToApprove == null || this.itemFilterToApprove.getResult(context, item));
    }

    public double getScoreToApprove() {
        return this.scoreToApprove;
    }

    public void setScoreToApprove(double scoreToApprove) {
        this.scoreToApprove = scoreToApprove;
    }

    public double getScoreToIgnore() {
        return this.scoreToIgnore;
    }

    public void setScoreToIgnore(double scoreToIgnore) {
        this.scoreToIgnore = scoreToIgnore;
    }

    public double getScoreToReject() {
        return this.scoreToReject;
    }

    public void setScoreToReject(double scoreToReject) {
        this.scoreToReject = scoreToReject;
    }

    public LogicalStatement getItemFilterToApprove() {
        return this.itemFilterToApprove;
    }

    public void setItemFilterToApprove(LogicalStatement itemFilterToApprove) {
        this.itemFilterToApprove = itemFilterToApprove;
    }

    public LogicalStatement getItemFilterToIgnore() {
        return this.itemFilterToIgnore;
    }

    public void setItemFilterToIgnore(LogicalStatement itemFilterToIgnore) {
        this.itemFilterToIgnore = itemFilterToIgnore;
    }

    public LogicalStatement getItemFilterToReject() {
        return this.itemFilterToReject;
    }

    public void setItemFilterToReject(LogicalStatement itemFilterToReject) {
        this.itemFilterToReject = itemFilterToReject;
    }
}

