/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dspace.content.Item;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidEntityType;
import org.dspace.orcid.model.factory.OrcidEntityFactory;
import org.dspace.orcid.service.OrcidEntityFactoryService;
import org.orcid.jaxb.model.v3.release.record.Activity;

public class OrcidEntityFactoryServiceImpl
implements OrcidEntityFactoryService {
    private final String INVALID_ENTITY_MSG = "The item with id %s is not a configured Orcid entity";
    private final Map<OrcidEntityType, OrcidEntityFactory> entityFactories;
    private final ItemService itemService;

    private OrcidEntityFactoryServiceImpl(List<OrcidEntityFactory> entityFactories, ItemService itemService) {
        this.itemService = itemService;
        this.entityFactories = entityFactories.stream().collect(Collectors.toMap(OrcidEntityFactory::getEntityType, Function.identity()));
    }

    @Override
    public Activity createOrcidObject(Context context, Item item) {
        OrcidEntityFactory factory = this.getOrcidEntityType(item).map(entityType -> this.entityFactories.get(entityType)).orElseThrow(() -> new IllegalArgumentException(String.format("The item with id %s is not a configured Orcid entity", item.getID())));
        return factory.createOrcidObject(context, item);
    }

    private Optional<OrcidEntityType> getOrcidEntityType(Item item) {
        return Optional.ofNullable(OrcidEntityType.fromEntityType(this.itemService.getEntityTypeLabel(item)));
    }
}

