/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model.factory.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dspace.content.MetadataValue;
import org.dspace.core.Context;
import org.dspace.orcid.model.OrcidProfileSectionType;
import org.dspace.orcid.model.factory.OrcidFactoryUtils;
import org.dspace.orcid.model.factory.impl.OrcidSimpleValueObjectFactory;
import org.dspace.profile.OrcidProfileSyncPreference;
import org.orcid.jaxb.model.common.Relationship;
import org.orcid.jaxb.model.v3.release.common.Url;
import org.orcid.jaxb.model.v3.release.record.PersonExternalIdentifier;

public class OrcidPersonExternalIdentifierFactory
extends OrcidSimpleValueObjectFactory {
    private Map<String, String> externalIds = new HashMap<String, String>();

    public OrcidPersonExternalIdentifierFactory(OrcidProfileSectionType sectionType, OrcidProfileSyncPreference preference) {
        super(sectionType, preference);
    }

    @Override
    public List<OrcidProfileSectionType> getSupportedTypes() {
        return List.of(OrcidProfileSectionType.EXTERNAL_IDS);
    }

    @Override
    protected Object create(Context context, MetadataValue metadataValue) {
        String currentMetadataField = metadataValue.getMetadataField().toString('.');
        String externalIdType = this.externalIds.get(currentMetadataField);
        if (externalIdType == null) {
            throw new IllegalArgumentException("Metadata field not supported: " + currentMetadataField);
        }
        PersonExternalIdentifier externalId = new PersonExternalIdentifier();
        externalId.setValue(metadataValue.getValue());
        externalId.setType(externalIdType);
        externalId.setRelationship(Relationship.SELF);
        externalId.setUrl(new Url(metadataValue.getValue()));
        return externalId;
    }

    public Map<String, String> getExternalIds() {
        return this.externalIds;
    }

    public void setExternalIds(String externalIds) {
        this.externalIds = OrcidFactoryUtils.parseConfigurations(externalIds);
        this.setMetadataFields(this.externalIds.keySet().stream().collect(Collectors.joining(",")));
    }
}

