/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.model;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dspace.orcid.model.factory.OrcidFactoryUtils;
import org.dspace.util.SimpleMapConverter;
import org.orcid.jaxb.model.common.FundingContributorRole;

public class OrcidFundingFieldMapping {
    private Map<String, FundingContributorRole> contributorFields;
    private Map<String, String> externalIdentifierFields;
    private String titleField;
    private String typeField;
    private SimpleMapConverter typeConverter;
    private String amountField;
    private String amountCurrencyField;
    private SimpleMapConverter amountCurrencyConverter;
    private String startDateField;
    private String endDateField;
    private String descriptionField;
    private String organizationRelationshipType;

    private Map<String, FundingContributorRole> parseContributors(String contributors) {
        Map<String, String> contributorsMap = OrcidFactoryUtils.parseConfigurations(contributors);
        return contributorsMap.keySet().stream().collect(Collectors.toMap(Function.identity(), field -> this.parseContributorRole((String)contributorsMap.get(field))));
    }

    private FundingContributorRole parseContributorRole(String contributorRole) {
        try {
            return FundingContributorRole.fromValue((String)contributorRole);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("The funding contributor role " + contributorRole + " is invalid, allowed values are " + this.getAllowedContributorRoles(), ex);
        }
    }

    private List<String> getAllowedContributorRoles() {
        return Arrays.asList(FundingContributorRole.values()).stream().map(FundingContributorRole::value).collect(Collectors.toList());
    }

    public Map<String, String> getExternalIdentifierFields() {
        return this.externalIdentifierFields;
    }

    public void setExternalIdentifierFields(String externalIdentifierFields) {
        this.externalIdentifierFields = OrcidFactoryUtils.parseConfigurations(externalIdentifierFields);
    }

    public Map<String, FundingContributorRole> getContributorFields() {
        return this.contributorFields;
    }

    public void setContributorFields(String contributorFields) {
        this.contributorFields = this.parseContributors(contributorFields);
    }

    public String getTitleField() {
        return this.titleField;
    }

    public void setTitleField(String titleField) {
        this.titleField = titleField;
    }

    public String getStartDateField() {
        return this.startDateField;
    }

    public void setStartDateField(String startDateField) {
        this.startDateField = startDateField;
    }

    public String getEndDateField() {
        return this.endDateField;
    }

    public void setEndDateField(String endDateField) {
        this.endDateField = endDateField;
    }

    public String getDescriptionField() {
        return this.descriptionField;
    }

    public void setDescriptionField(String descriptionField) {
        this.descriptionField = descriptionField;
    }

    public String getOrganizationRelationshipType() {
        return this.organizationRelationshipType;
    }

    public void setOrganizationRelationshipType(String organizationRelationshipType) {
        this.organizationRelationshipType = organizationRelationshipType;
    }

    public String getTypeField() {
        return this.typeField;
    }

    public void setTypeField(String typeField) {
        this.typeField = typeField;
    }

    public String getAmountField() {
        return this.amountField;
    }

    public void setAmountField(String amountField) {
        this.amountField = amountField;
    }

    public String getAmountCurrencyField() {
        return this.amountCurrencyField;
    }

    public void setAmountCurrencyField(String amountCurrencyField) {
        this.amountCurrencyField = amountCurrencyField;
    }

    public String convertAmountCurrency(String currency) {
        return this.amountCurrencyConverter != null ? this.amountCurrencyConverter.getValue(currency) : currency;
    }

    public void setAmountCurrencyConverter(SimpleMapConverter amountCurrencyConverter) {
        this.amountCurrencyConverter = amountCurrencyConverter;
    }

    public String convertType(String type) {
        return this.typeConverter != null ? this.typeConverter.getValue(type) : type;
    }

    public void setTypeConverter(SimpleMapConverter typeConverter) {
        this.typeConverter = typeConverter;
    }
}

