/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.orcid.exception;

import java.util.List;
import java.util.stream.Collectors;
import org.dspace.orcid.model.validator.OrcidValidationError;

public class OrcidValidationException
extends RuntimeException {
    private static final long serialVersionUID = 3377335341871311369L;
    private final List<OrcidValidationError> errors;

    public OrcidValidationException(OrcidValidationError error) {
        this(List.of(error));
    }

    public OrcidValidationException(List<OrcidValidationError> errors) {
        super("Errors occurs during ORCID object validation");
        this.errors = errors;
    }

    public List<OrcidValidationError> getErrors() {
        return this.errors;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + ". Error codes: " + this.formatErrors();
    }

    private String formatErrors() {
        return this.errors.stream().map(error -> error.getCode()).collect(Collectors.joining(","));
    }
}

