/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.scopus.service;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.DoiCheck;
import org.dspace.importer.external.service.components.QuerySource;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScopusImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<Element>
implements QuerySource {
    private int timeout = 1000;
    int itemPerPage = 25;
    private String url;
    private String apiKey;
    private String instKey;
    private String viewMode;
    @Autowired
    private LiveImportClient liveImportClient;
    private static final Logger log = LogManager.getLogger();

    public LiveImportClient getLiveImportClient() {
        return this.liveImportClient;
    }

    public void setLiveImportClient(LiveImportClient liveImportClient) {
        this.liveImportClient = liveImportClient;
    }

    @Override
    public void init() throws Exception {
    }

    @Override
    public String getImportSource() {
        return "scopus";
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        if (this.isEID(query)) {
            return this.retry(new FindByIdCallable(query)).size();
        }
        if (DoiCheck.isDoi(query)) {
            query = DoiCheck.purgeDoiValue(query);
        }
        return this.retry(new SearchNBByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        if (this.isEID(query.toString())) {
            return this.retry(new FindByIdCallable(query.toString())).size();
        }
        if (DoiCheck.isDoi(query.toString())) {
            query.addParameter("query", DoiCheck.purgeDoiValue(query.toString()));
        }
        return this.retry(new SearchNBByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        if (this.isEID(query)) {
            return this.retry(new FindByIdCallable(query));
        }
        if (DoiCheck.isDoi(query)) {
            query = DoiCheck.purgeDoiValue(query);
        }
        return this.retry(new SearchByQueryCallable(query, count, start));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        if (this.isEID(query.toString())) {
            return this.retry(new FindByIdCallable(query.toString()));
        }
        if (DoiCheck.isDoi(query.toString())) {
            query.addParameter("query", DoiCheck.purgeDoiValue(query.toString()));
        }
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = null;
        if (DoiCheck.isDoi(query.toString())) {
            query.addParameter("query", DoiCheck.purgeDoiValue(query.toString()));
        }
        records = this.isEID(query.toString()) ? this.retry(new FindByIdCallable(query.toString())) : this.retry(new SearchByQueryCallable(query));
        return records == null || records.isEmpty() ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for Scopus");
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new FindByIdCallable(id));
        return records == null || records.isEmpty() ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        if (this.isEID(query.toString())) {
            return this.retry(new FindByIdCallable(query.toString()));
        }
        if (DoiCheck.isDoi(query.toString())) {
            query.addParameter("query", DoiCheck.purgeDoiValue(query.toString()));
        }
        return this.retry(new FindByQueryCallable(query));
    }

    private boolean isEID(String query) {
        Pattern pattern = Pattern.compile("2-s2\\.0-\\d+");
        Matcher match = pattern.matcher(query);
        return match.matches();
    }

    private Map<String, String> getRequestParameters(String query, String viewMode, Integer start, Integer count) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("httpAccept", "application/xml");
        params.put("apiKey", this.apiKey);
        params.put("query", query);
        if (StringUtils.isNotBlank((CharSequence)this.instKey)) {
            params.put("insttoken", this.instKey);
        }
        if (StringUtils.isNotBlank((CharSequence)viewMode)) {
            params.put("view", viewMode);
        }
        params.put("start", (String)(Objects.nonNull(start) ? "" + start : "0"));
        params.put("count", (String)(Objects.nonNull(count) ? "" + count : "20"));
        return params;
    }

    private List<Element> splitToRecords(String recordsSrc) {
        try {
            SAXBuilder saxBuilder = XMLUtils.getSAXBuilder();
            Document document = saxBuilder.build((Reader)new StringReader(recordsSrc));
            Element root = document.getRootElement();
            String totalResults = root.getChildText("totalResults", Namespace.getNamespace((String)"http://a9.com/-/spec/opensearch/1.1/"));
            if (totalResults != null && "0".equals(totalResults)) {
                log.debug("got Scopus API with empty response");
                return Collections.emptyList();
            }
            List records = root.getChildren("entry", Namespace.getNamespace((String)"http://www.w3.org/2005/Atom"));
            return records;
        }
        catch (IOException | JDOMException e) {
            log.warn("got unexpected XML response from Scopus API: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getInstKey() {
        return this.instKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setInstKey(String instKey) {
        this.instKey = instKey;
    }

    private class FindByIdCallable
    implements Callable<List<ImportRecord>> {
        private String eid;

        private FindByIdCallable(String eid) {
            this.eid = eid;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String queryString = "EID(" + this.eid.replace("!", "/") + ")";
            if (StringUtils.isNotBlank((CharSequence)ScopusImportMetadataSourceServiceImpl.this.apiKey)) {
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                Map<String, String> requestParams = ScopusImportMetadataSourceServiceImpl.this.getRequestParameters(queryString, ScopusImportMetadataSourceServiceImpl.this.viewMode, null, null);
                params.put("uriParameters", requestParams);
                String response = ScopusImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScopusImportMetadataSourceServiceImpl.this.timeout, ScopusImportMetadataSourceServiceImpl.this.url, params);
                if (StringUtils.isEmpty((CharSequence)response)) {
                    return results;
                }
                List<Element> elements = ScopusImportMetadataSourceServiceImpl.this.splitToRecords(response);
                for (Element record : elements) {
                    results.add(ScopusImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
            }
            return results;
        }
    }

    private class SearchNBByQueryCallable
    implements Callable<Integer> {
        private String query;

        private SearchNBByQueryCallable(String queryString) {
            this.query = queryString;
        }

        private SearchNBByQueryCallable(Query query) {
            this.query = query.getParameterAsClass("query", String.class);
        }

        @Override
        public Integer call() throws Exception {
            if (StringUtils.isNotBlank((CharSequence)ScopusImportMetadataSourceServiceImpl.this.apiKey)) {
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                Map<String, String> requestParams = ScopusImportMetadataSourceServiceImpl.this.getRequestParameters(this.query, null, null, null);
                params.put("uriParameters", requestParams);
                String response = ScopusImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScopusImportMetadataSourceServiceImpl.this.timeout, ScopusImportMetadataSourceServiceImpl.this.url, params);
                if (StringUtils.isEmpty((CharSequence)response)) {
                    return 0;
                }
                SAXBuilder saxBuilder = XMLUtils.getSAXBuilder();
                Document document = saxBuilder.build((Reader)new StringReader(response));
                Element root = document.getRootElement();
                List<Namespace> namespaces = Arrays.asList(Namespace.getNamespace((String)"opensearch", (String)"http://a9.com/-/spec/opensearch/1.1/"));
                XPathExpression xpath = XPathFactory.instance().compile("opensearch:totalResults", Filters.element(), null, namespaces);
                Element count = (Element)xpath.evaluateFirst((Object)root);
                try {
                    return Integer.parseInt(count.getText());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            return null;
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString, Integer maxResult, Integer start) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
            this.query.addParameter("start", start);
            this.query.addParameter("count", maxResult);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String queryString = this.query.getParameterAsClass("query", String.class);
            Integer start = this.query.getParameterAsClass("start", Integer.class);
            Integer count = this.query.getParameterAsClass("count", Integer.class);
            if (StringUtils.isNotBlank((CharSequence)ScopusImportMetadataSourceServiceImpl.this.apiKey)) {
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                Map<String, String> requestParams = ScopusImportMetadataSourceServiceImpl.this.getRequestParameters(queryString, ScopusImportMetadataSourceServiceImpl.this.viewMode, start, count);
                params.put("uriParameters", requestParams);
                String response = ScopusImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScopusImportMetadataSourceServiceImpl.this.timeout, ScopusImportMetadataSourceServiceImpl.this.url, params);
                if (StringUtils.isEmpty((CharSequence)response)) {
                    return results;
                }
                List<Element> elements = ScopusImportMetadataSourceServiceImpl.this.splitToRecords(response);
                for (Element record : elements) {
                    results.add(ScopusImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
            }
            return results;
        }
    }

    private class FindByQueryCallable
    implements Callable<List<ImportRecord>> {
        private String title;
        private String author;
        private Integer year;
        private Integer start;
        private Integer count;

        private FindByQueryCallable(Query query) {
            this.title = query.getParameterAsClass("title", String.class);
            this.year = query.getParameterAsClass("year", Integer.class);
            this.author = query.getParameterAsClass("author", String.class);
            this.start = query.getParameterAsClass("start", Integer.class) != null ? query.getParameterAsClass("start", Integer.class) : Integer.valueOf(0);
            this.count = query.getParameterAsClass("count", Integer.class) != null ? query.getParameterAsClass("count", Integer.class) : Integer.valueOf(20);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            ArrayList<ImportRecord> results = new ArrayList<ImportRecord>();
            String queryString = "";
            StringBuffer query = new StringBuffer();
            if (StringUtils.isNotBlank((CharSequence)this.title)) {
                query.append("title(").append(this.title).append("");
            }
            if (StringUtils.isNotBlank((CharSequence)this.author)) {
                if (query.length() > 0) {
                    query.append(" AND ");
                }
                query.append("AUTH(").append(this.author).append(")");
            }
            if (this.year != -1) {
                if (query.length() > 0) {
                    query.append(" AND ");
                }
                query.append("PUBYEAR IS ").append(this.year);
            }
            queryString = query.toString();
            if (ScopusImportMetadataSourceServiceImpl.this.apiKey != null && !ScopusImportMetadataSourceServiceImpl.this.apiKey.equals("")) {
                HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
                Map<String, String> requestParams = ScopusImportMetadataSourceServiceImpl.this.getRequestParameters(queryString, ScopusImportMetadataSourceServiceImpl.this.viewMode, this.start, this.count);
                params.put("uriParameters", requestParams);
                String response = ScopusImportMetadataSourceServiceImpl.this.liveImportClient.executeHttpGetRequest(ScopusImportMetadataSourceServiceImpl.this.timeout, ScopusImportMetadataSourceServiceImpl.this.url, params);
                if (StringUtils.isEmpty((CharSequence)response)) {
                    return results;
                }
                List<Element> elements = ScopusImportMetadataSourceServiceImpl.this.splitToRecords(response);
                for (Element record : elements) {
                    results.add(ScopusImportMetadataSourceServiceImpl.this.transformSourceRecords(record));
                }
            }
            return results;
        }
    }
}

