/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.ror.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Item;
import org.dspace.importer.external.datamodel.ImportRecord;
import org.dspace.importer.external.datamodel.Query;
import org.dspace.importer.external.exception.MetadataSourceException;
import org.dspace.importer.external.liveimportclient.service.LiveImportClient;
import org.dspace.importer.external.service.AbstractImportMetadataSourceService;
import org.dspace.importer.external.service.components.QuerySource;
import org.springframework.beans.factory.annotation.Autowired;

public class RorImportMetadataSourceServiceImpl
extends AbstractImportMetadataSourceService<String>
implements QuerySource {
    private static final Logger log = LogManager.getLogger();
    protected static final String ROR_IDENTIFIER_PREFIX = "https://ror.org/";
    private String url;
    private int timeout = 1000;
    @Autowired
    private LiveImportClient liveImportClient;

    @Override
    public String getImportSource() {
        return "ror";
    }

    @Override
    public ImportRecord getRecord(String id) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(id));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public int getRecordsCount(String query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public int getRecordsCount(Query query) throws MetadataSourceException {
        return this.retry(new CountByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(String query, int start, int count) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public Collection<ImportRecord> getRecords(Query query) throws MetadataSourceException {
        return this.retry(new SearchByQueryCallable(query));
    }

    @Override
    public ImportRecord getRecord(Query query) throws MetadataSourceException {
        List<ImportRecord> records = this.retry(new SearchByIdCallable(query));
        return CollectionUtils.isEmpty(records) ? null : records.get(0);
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Query query) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for ROR");
    }

    @Override
    public Collection<ImportRecord> findMatchingRecords(Item item) throws MetadataSourceException {
        throw new UnsupportedOperationException("This method is not implemented for ROR");
    }

    @Override
    public void init() throws Exception {
    }

    public Integer count(String query) {
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            URIBuilder uriBuilder = new URIBuilder(this.url);
            uriBuilder.addParameter("query", query);
            String resp = this.liveImportClient.executeHttpGetRequest(this.timeout, uriBuilder.toString(), params);
            if (StringUtils.isEmpty((CharSequence)resp)) {
                return 0;
            }
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            return jsonNode.at("/number_of_results").asInt();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private List<ImportRecord> searchById(String id) {
        ArrayList<ImportRecord> importResults = new ArrayList<ImportRecord>();
        id = StringUtils.removeStart((String)id, (String)ROR_IDENTIFIER_PREFIX);
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            URIBuilder uriBuilder = new URIBuilder(this.url + "/" + id);
            String resp = this.liveImportClient.executeHttpGetRequest(this.timeout, uriBuilder.toString(), params);
            if (StringUtils.isEmpty((CharSequence)resp)) {
                return importResults;
            }
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            importResults.add(this.transformSourceRecords(jsonNode.toString()));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return importResults;
    }

    private List<ImportRecord> search(String query) {
        ArrayList<ImportRecord> importResults = new ArrayList<ImportRecord>();
        try {
            HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
            URIBuilder uriBuilder = new URIBuilder(this.url);
            uriBuilder.addParameter("query", query);
            String resp = this.liveImportClient.executeHttpGetRequest(this.timeout, uriBuilder.toString(), params);
            if (StringUtils.isEmpty((CharSequence)resp)) {
                return importResults;
            }
            JsonNode jsonNode = this.convertStringJsonToJsonNode(resp);
            JsonNode docs = jsonNode.at("/items");
            if (docs.isArray()) {
                Iterator nodes = docs.elements();
                while (nodes.hasNext()) {
                    JsonNode node = (JsonNode)nodes.next();
                    importResults.add(this.transformSourceRecords(node.toString()));
                }
            } else {
                importResults.add(this.transformSourceRecords(docs.toString()));
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return importResults;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        try {
            return new ObjectMapper().readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
            return null;
        }
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private class SearchByIdCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByIdCallable(Query query) {
            this.query = query;
        }

        private SearchByIdCallable(String id) {
            this.query = new Query();
            this.query.addParameter("id", id);
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            return RorImportMetadataSourceServiceImpl.this.searchById(this.query.getParameterAsClass("id", String.class));
        }
    }

    private class CountByQueryCallable
    implements Callable<Integer> {
        private Query query;

        private CountByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private CountByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public Integer call() throws Exception {
            return RorImportMetadataSourceServiceImpl.this.count(this.query.getParameterAsClass("query", String.class));
        }
    }

    private class SearchByQueryCallable
    implements Callable<List<ImportRecord>> {
        private Query query;

        private SearchByQueryCallable(String queryString) {
            this.query = new Query();
            this.query.addParameter("query", queryString);
        }

        private SearchByQueryCallable(Query query) {
            this.query = query;
        }

        @Override
        public List<ImportRecord> call() throws Exception {
            return RorImportMetadataSourceServiceImpl.this.search(this.query.getParameterAsClass("query", String.class));
        }
    }
}

