/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.transform;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;
import org.dspace.util.SimpleMapConverter;

public class StringJsonValueMappingMetadataProcessorService
implements JsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger();
    private SimpleMapConverter valueMapConverter;
    private String path;

    @Override
    public Collection<String> processMetadata(String json) {
        JsonNode rootNode = this.convertStringJsonToJsonNode(json);
        Optional<JsonNode> abstractNode = Optional.of(rootNode.at(this.path));
        ArrayList<String> values = new ArrayList<String>();
        if (abstractNode.isPresent() && abstractNode.get().getNodeType().equals((Object)JsonNodeType.STRING)) {
            String stringValue = abstractNode.get().asText();
            values.add(Optional.ofNullable(stringValue).map(value -> this.valueMapConverter != null ? this.valueMapConverter.getValue((String)value) : value).orElse(this.valueMapConverter.getValue(null)));
        }
        return values;
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    public String convertType(String type) {
        return this.valueMapConverter != null ? this.valueMapConverter.getValue(type) : type;
    }

    public void setValueMapConverter(SimpleMapConverter valueMapConverter) {
        this.valueMapConverter = valueMapConverter;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

