/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SimpleXpathMetadatumContributor
implements MetadataContributor<Element> {
    private static final Logger log = LogManager.getLogger();
    protected MetadataFieldConfig field;
    protected MetadataFieldMapping<Element, MetadataContributor<Element>> metadataFieldMapping;
    protected Map<String, String> prefixToNamespaceMapping;
    protected String query;

    public Map<String, String> getPrefixToNamespaceMapping() {
        return this.prefixToNamespaceMapping;
    }

    public MetadataFieldMapping<Element, MetadataContributor<Element>> getMetadataFieldMapping() {
        return this.metadataFieldMapping;
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<Element, MetadataContributor<Element>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
    }

    @Resource(name="isiFullprefixMapping")
    public void setPrefixToNamespaceMapping(Map<String, String> prefixToNamespaceMapping) {
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
    }

    public SimpleXpathMetadatumContributor(String query, Map<String, String> prefixToNamespaceMapping, MetadataFieldConfig field) {
        this.query = query;
        this.prefixToNamespaceMapping = prefixToNamespaceMapping;
        this.field = field;
    }

    public SimpleXpathMetadatumContributor() {
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }

    @Autowired(required=true)
    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public String getQuery() {
        return this.query;
    }

    @Autowired(required=true)
    public void setQuery(String query) {
        this.query = query;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Element t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (String ns : this.prefixToNamespaceMapping.keySet()) {
            namespaces.add(Namespace.getNamespace((String)this.prefixToNamespaceMapping.get(ns), (String)ns));
        }
        XPathExpression xpath = XPathFactory.instance().compile(this.query, Filters.fpassthrough(), null, namespaces);
        List nodes = xpath.evaluate((Object)t);
        for (Object el : nodes) {
            if (el instanceof Element) {
                values.add(this.metadataFieldMapping.toDCValue(this.field, ((Element)el).getText()));
                continue;
            }
            if (el instanceof Attribute) {
                values.add(this.metadataFieldMapping.toDCValue(this.field, ((Attribute)el).getValue()));
                continue;
            }
            if (el instanceof String) {
                values.add(this.metadataFieldMapping.toDCValue(this.field, (String)el));
                continue;
            }
            if (el instanceof Text) {
                values.add(this.metadataFieldMapping.toDCValue(this.field, ((Text)el).getText()));
                continue;
            }
            log.error("Encountered unsupported XML node of type: {}. Skipped that node.", el.getClass());
        }
        return values;
    }
}

