/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.Collection;
import java.util.LinkedList;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadataFieldMapping;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.MetadataContributor;
import org.dspace.importer.external.service.components.dto.PlainMetadataKeyValueItem;
import org.dspace.importer.external.service.components.dto.PlainMetadataSourceDto;

public class SimpleMetadataContributor
implements MetadataContributor<PlainMetadataSourceDto> {
    private MetadataFieldConfig field;
    private String key;
    private MetadataFieldMapping<PlainMetadataSourceDto, MetadataContributor<PlainMetadataSourceDto>> metadataFieldMapping;

    public SimpleMetadataContributor(MetadataFieldConfig field, String key) {
        this.field = field;
        this.key = key;
    }

    public SimpleMetadataContributor() {
    }

    @Override
    public void setMetadataFieldMapping(MetadataFieldMapping<PlainMetadataSourceDto, MetadataContributor<PlainMetadataSourceDto>> metadataFieldMapping) {
        this.metadataFieldMapping = metadataFieldMapping;
    }

    @Override
    public Collection<MetadatumDTO> contributeMetadata(PlainMetadataSourceDto t) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        for (PlainMetadataKeyValueItem metadatum : t.getMetadata()) {
            if (!this.key.equals(metadatum.getKey())) continue;
            MetadatumDTO dcValue = new MetadatumDTO();
            dcValue.setValue(metadatum.getValue());
            dcValue.setElement(this.field.getElement());
            dcValue.setQualifier(this.field.getQualifier());
            dcValue.setSchema(this.field.getSchema());
            values.add(dcValue);
        }
        return values;
    }

    public void setField(MetadataFieldConfig field) {
        this.field = field;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public MetadataFieldConfig getField() {
        return this.field;
    }
}

