/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.metadatamapping.contributor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.dspace.importer.external.metadatamapping.MetadataFieldConfig;
import org.dspace.importer.external.metadatamapping.MetadatumDTO;
import org.dspace.importer.external.metadatamapping.contributor.SimpleXpathMetadatumContributor;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PageRangeXPathMetadataContributor
extends SimpleXpathMetadatumContributor {
    private MetadataFieldConfig startPageMetadata;
    private MetadataFieldConfig endPageMetadata;

    @Override
    public Collection<MetadatumDTO> contributeMetadata(Element el) {
        LinkedList<MetadatumDTO> values = new LinkedList<MetadatumDTO>();
        List<MetadatumDTO> metadatums = null;
        for (String ns : this.prefixToNamespaceMapping.keySet()) {
            List nodes = el.getChildren(this.query, Namespace.getNamespace((String)ns));
            for (Element element : nodes) {
                metadatums = this.getMetadatum(element.getValue());
                if (!Objects.nonNull(metadatums)) continue;
                for (MetadatumDTO metadatum : metadatums) {
                    values.add(metadatum);
                }
            }
        }
        return values;
    }

    private List<MetadatumDTO> getMetadatum(String value) {
        ArrayList<MetadatumDTO> metadatums = new ArrayList<MetadatumDTO>();
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String[] range = value.split("-");
        if (range.length == 2) {
            metadatums.add(this.setStartPage(range));
            metadatums.add(this.setEndPage(range));
        } else if (range.length != 0) {
            metadatums.add(this.setStartPage(range));
        }
        return metadatums;
    }

    private MetadatumDTO setEndPage(String[] range) {
        MetadatumDTO endPage = new MetadatumDTO();
        endPage.setValue(range[1]);
        endPage.setElement(this.endPageMetadata.getElement());
        endPage.setQualifier(this.endPageMetadata.getQualifier());
        endPage.setSchema(this.endPageMetadata.getSchema());
        return endPage;
    }

    private MetadatumDTO setStartPage(String[] range) {
        MetadatumDTO startPage = new MetadatumDTO();
        startPage.setValue(range[0]);
        startPage.setElement(this.startPageMetadata.getElement());
        startPage.setQualifier(this.startPageMetadata.getQualifier());
        startPage.setSchema(this.startPageMetadata.getSchema());
        return startPage;
    }

    public MetadataFieldConfig getStartPageMetadata() {
        return this.startPageMetadata;
    }

    public void setStartPageMetadata(MetadataFieldConfig startPageMetadata) {
        this.startPageMetadata = startPageMetadata;
    }

    public MetadataFieldConfig getEndPageMetadata() {
        return this.endPageMetadata;
    }

    public void setEndPageMetadata(MetadataFieldConfig endPageMetadata) {
        this.endPageMetadata = endPageMetadata;
    }
}

