/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.identifier.ezid;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.identifier.IdentifierException;

public class EZIDResponse {
    private static final Logger log = LogManager.getLogger();
    private static final String UTF_8 = "UTF-8";
    private final String status;
    private final String statusValue;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final HttpResponse response;

    public EZIDResponse(HttpResponse response) throws IdentifierException {
        String body;
        this.response = response;
        HttpEntity responseBody = response.getEntity();
        try {
            body = EntityUtils.toString((HttpEntity)responseBody, (String)UTF_8);
        }
        catch (IOException | ParseException ex) {
            log.error(((Exception)ex)::getMessage);
            throw new IdentifierException("EZID response not understood:  " + ex.getMessage());
        }
        String[] lines = body.split("[\\n\\r]");
        String[] parts = lines[0].split(":", 2);
        this.status = parts[0].trim();
        this.statusValue = parts.length > 1 ? parts[1].trim() : null;
        for (int i = 1; i < lines.length; ++i) {
            parts = lines[i].split(":", 2);
            String key = null;
            String value = null;
            try {
                key = URLDecoder.decode(parts[0], UTF_8).trim();
                value = parts.length > 1 ? URLDecoder.decode(parts[1], UTF_8).trim() : null;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.attributes.put(key, value);
        }
    }

    public boolean isSuccess() {
        return this.status.equalsIgnoreCase("success");
    }

    public String getEZIDStatus() {
        return this.status;
    }

    public String getEZIDStatusValue() {
        return this.statusValue;
    }

    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.attributes.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public String get(String key) {
        return this.attributes.get(key);
    }

    public int getHttpStatusCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    public String getHttpReasonPhrase() {
        return this.response.getStatusLine().getReasonPhrase();
    }
}

