/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import org.dspace.content.Collection;
import org.dspace.core.ReloadableEntity;

@Entity
@Table(name="harvested_collection")
public class HarvestedCollection
implements ReloadableEntity<Integer> {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="harvested_collection_seq")
    @SequenceGenerator(name="harvested_collection_seq", sequenceName="harvested_collection_seq", allocationSize=1)
    private Integer id;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="collection_id")
    private Collection collection;
    @Column(name="harvest_type")
    private int harvestType;
    @Column(name="oai_source")
    private String oaiSource;
    @Column(name="oai_set_id")
    private String oaiSetId;
    @Column(name="harvest_message")
    private String harvestMessage;
    @Column(name="metadata_config_id")
    private String metadataConfigId;
    @Column(name="harvest_status")
    private int harvestStatus;
    @Column(name="harvest_start_time", columnDefinition="timestamp with time zone")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date harvestStartTime;
    @Column(name="last_harvested", columnDefinition="timestamp with time zone")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastHarvested;
    @Transient
    public static final int TYPE_NONE = 0;
    @Transient
    public static final int TYPE_DMD = 1;
    @Transient
    public static final int TYPE_DMDREF = 2;
    @Transient
    public static final int TYPE_FULL = 3;
    @Transient
    public static final int STATUS_READY = 0;
    @Transient
    public static final int STATUS_BUSY = 1;
    @Transient
    public static final int STATUS_QUEUED = 2;
    @Transient
    public static final int STATUS_OAI_ERROR = 3;
    @Transient
    public static final int STATUS_UNKNOWN_ERROR = -1;

    protected HarvestedCollection() {
    }

    @Override
    public Integer getID() {
        return this.id;
    }

    public void setHarvestParams(int type, String oaiSource, String oaiSetId, String mdConfigId) {
        this.setHarvestType(type);
        this.setOaiSource(oaiSource);
        this.setOaiSetId(oaiSetId);
        this.setHarvestMetadataConfig(mdConfigId);
    }

    public void setHarvestType(int type) {
        this.harvestType = type;
    }

    public void setHarvestStatus(int status) {
        this.harvestStatus = status;
    }

    public void setOaiSource(String oaiSource) {
        this.oaiSource = oaiSource;
    }

    public void setOaiSetId(String oaiSetId) {
        this.oaiSetId = oaiSetId;
    }

    public void setHarvestMetadataConfig(String mdConfigId) {
        this.metadataConfigId = mdConfigId;
    }

    public void setLastHarvested(Date lastHarvested) {
        this.lastHarvested = lastHarvested;
    }

    public void setHarvestMessage(String message) {
        this.harvestMessage = message;
    }

    public void setHarvestStartTime(Date date) {
        this.harvestStartTime = date;
    }

    public Collection getCollection() {
        return this.collection;
    }

    void setCollection(Collection collection) {
        this.collection = collection;
    }

    public int getHarvestType() {
        return this.harvestType;
    }

    public int getHarvestStatus() {
        return this.harvestStatus;
    }

    public String getOaiSource() {
        return this.oaiSource;
    }

    public String getOaiSetId() {
        return this.oaiSetId;
    }

    public String getHarvestMetadataConfig() {
        return this.metadataConfigId;
    }

    public String getHarvestMessage() {
        return this.harvestMessage;
    }

    public Date getHarvestDate() {
        return this.lastHarvested;
    }

    public Date getHarvestStartTime() {
        return this.harvestStartTime;
    }
}

