/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.external.provider.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.dspace.app.sherpa.SHERPAService;
import org.dspace.app.sherpa.v2.SHERPAJournal;
import org.dspace.app.sherpa.v2.SHERPAResponse;
import org.dspace.app.sherpa.v2.SHERPAUtils;
import org.dspace.content.dto.MetadataValueDTO;
import org.dspace.external.model.ExternalDataObject;
import org.dspace.external.provider.AbstractExternalDataProvider;

public class SHERPAv2JournalDataProvider
extends AbstractExternalDataProvider {
    private String sourceIdentifier;
    SHERPAService sherpaService;

    @Override
    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void init() throws IOException {
    }

    @Override
    public Optional<ExternalDataObject> getExternalDataObject(String id) {
        SHERPAResponse sherpaResponse = this.sherpaService.performRequest("publication", "title", "equals", id = SHERPAUtils.sanitiseQuery(id), 0, 1);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getJournals())) {
            SHERPAJournal sherpaJournal = sherpaResponse.getJournals().get(0);
            ExternalDataObject externalDataObject = this.constructExternalDataObjectFromSherpaJournal(sherpaJournal);
            return Optional.of(externalDataObject);
        }
        return Optional.empty();
    }

    private ExternalDataObject constructExternalDataObjectFromSherpaJournal(SHERPAJournal sherpaJournal) {
        ExternalDataObject externalDataObject = new ExternalDataObject();
        externalDataObject.setSource(this.sourceIdentifier);
        if (CollectionUtils.isNotEmpty(sherpaJournal.getTitles())) {
            String journalTitle = sherpaJournal.getTitles().get(0);
            externalDataObject.setId(sherpaJournal.getTitles().get(0));
            externalDataObject.addMetadata(new MetadataValueDTO("dc", "title", null, null, journalTitle));
            externalDataObject.setValue(journalTitle);
            externalDataObject.setDisplayValue(journalTitle);
        }
        if (CollectionUtils.isNotEmpty(sherpaJournal.getIssns())) {
            String issn = sherpaJournal.getIssns().get(0);
            externalDataObject.addMetadata(new MetadataValueDTO("creativeworkseries", "issn", null, null, issn));
        }
        return externalDataObject;
    }

    @Override
    public List<ExternalDataObject> searchExternalDataObjects(String query, int start, int limit) {
        SHERPAResponse sherpaResponse = this.sherpaService.performRequest("publication", "title", "contains word", query, start, limit);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getJournals())) {
            List<ExternalDataObject> list = sherpaResponse.getJournals().stream().map(sherpaJournal -> this.constructExternalDataObjectFromSherpaJournal((SHERPAJournal)sherpaJournal)).collect(Collectors.toList());
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean supports(String source) {
        return StringUtils.equalsIgnoreCase((CharSequence)this.sourceIdentifier, (CharSequence)source);
    }

    @Override
    public int getNumberOfResults(String query) {
        SHERPAResponse sherpaResponse = this.sherpaService.performRequest("publication", "title", "contains word", query, 0, 0);
        if (CollectionUtils.isNotEmpty(sherpaResponse.getJournals())) {
            return sherpaResponse.getJournals().size();
        }
        return 0;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public void setSherpaService(SHERPAService sherpaService) {
        this.sherpaService = sherpaService;
    }
}

