/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.core.Context;

public class IndexingUtils {
    private IndexingUtils() {
    }

    static List<Community> getAncestorCommunities(Context context, Community community) throws SQLException {
        ArrayList<Community> communities = new ArrayList<Community>();
        while (community != null) {
            communities.add(community);
            community = (Community)ContentServiceFactory.getInstance().getDSpaceObjectService(community).getParentObject(context, community);
        }
        return communities;
    }

    static List<UUID> findTransitiveAdminGroupIds(Context context, Community community) throws SQLException {
        return IndexingUtils.getAncestorCommunities(context, community).stream().filter(parent -> parent.getAdministrators() != null).map(parent -> parent.getAdministrators().getID()).collect(Collectors.toList());
    }

    static List<UUID> findTransitiveAdminGroupIds(Context context, Collection collection) throws SQLException {
        ArrayList<UUID> ids = new ArrayList<UUID>();
        if (collection.getAdministrators() != null) {
            ids.add(collection.getAdministrators().getID());
        }
        for (Community community : collection.getCommunities()) {
            for (UUID id : IndexingUtils.findTransitiveAdminGroupIds(context, community)) {
                ids.add(id);
            }
        }
        return ids;
    }

    static List<String> findDirectlyAuthorizedGroupAndEPersonPrefixedIds(AuthorizeService authService, Context context, DSpaceObject obj, int[] authorizations) throws SQLException {
        ArrayList<String> prefixedIds = new ArrayList<String>();
        for (int auth : authorizations) {
            for (ResourcePolicy policy : authService.getPoliciesActionFilter(context, obj, auth)) {
                if (policy.getGroup() == null && policy.getEPerson() == null) continue;
                String prefixedId = policy.getGroup() == null ? "e" + policy.getEPerson().getID() : "g" + policy.getGroup().getID();
                prefixedIds.add(prefixedId);
                context.uncacheEntity(policy);
            }
        }
        return prefixedIds;
    }
}

