/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.ctask.general;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.curate.AbstractCurationTask;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class BasicLinkChecker
extends AbstractCurationTask {
    private int status = -2;
    private List<String> results = null;
    private static Logger log = LogManager.getLogger(BasicLinkChecker.class);
    protected static final ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    @Override
    public int perform(DSpaceObject dso) throws IOException {
        StringBuilder results = new StringBuilder();
        this.status = 2;
        if (dso instanceof Item) {
            Item item = (Item)dso;
            List<String> urls = this.getURLs(item);
            this.status = 2;
            results.append("Item: ").append(this.getItemHandle(item)).append("\n");
            for (String url : urls) {
                boolean ok = this.checkURL(url, results);
                if (ok) {
                    this.status = 0;
                    continue;
                }
                this.status = 1;
            }
        }
        this.setResult(results.toString());
        this.report(results.toString());
        return this.status;
    }

    protected List<String> getURLs(Item item) {
        List<MetadataValue> urls = this.itemService.getMetadata(item, "*", "*", "uri", "*");
        ArrayList<String> theURLs = new ArrayList<String>();
        for (MetadataValue url : urls) {
            theURLs.add(url.getValue());
        }
        return theURLs;
    }

    protected boolean checkURL(String url, StringBuilder results) {
        int redirects = 0;
        int httpStatus = this.getResponseStatus(url, redirects);
        if (httpStatus >= 200 && httpStatus < 300) {
            results.append(" - " + url + " = " + httpStatus + " - OK\n");
            return true;
        }
        results.append(" - " + url + " = " + httpStatus + " - FAILED\n");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int getResponseStatus(String url, int redirects) {
        RequestConfig config = RequestConfig.custom().setRedirectsEnabled(true).build();
        try (CloseableHttpClient httpClient = DSpaceHttpClientFactory.getInstance().buildWithRequestConfig(config);){
            String newUrl;
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(url));
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            int maxRedirect = configurationService.getIntProperty("curate.checklinks.max-redirect", 0);
            if (!(statusCode != 302 && statusCode != 301 && statusCode != 303 || (newUrl = httpResponse.getFirstHeader("Location").getValue()) == null || maxRedirect < redirects && maxRedirect != -1)) {
                int n2 = this.getResponseStatus(newUrl, ++redirects);
                return n2;
            }
            int n = statusCode;
            return n;
        }
        catch (IOException ioe) {
            log.debug("Bad link: " + ioe.getMessage());
            return 0;
        }
    }

    protected String getItemHandle(Item item) {
        String handle = item.getHandle();
        return handle != null ? handle : " in workflow";
    }
}

