/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.loader.StringResourceLoader;
import org.apache.velocity.runtime.resource.util.StringResourceRepository;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class LDN {
    private String content = "";
    private String contentName;
    private final List<Object> arguments = new ArrayList<Object>(20);
    private static final Logger LOG = LogManager.getLogger();
    private static final String RESOURCE_REPOSITORY_NAME = "LDN";
    private static final Properties VELOCITY_PROPERTIES = new Properties();
    private Template template = null;

    public void setContent(String name, String cnt) {
        this.content = cnt;
        this.contentName = name;
        this.arguments.clear();
    }

    public void addArgument(Object arg) {
        this.arguments.add(arg);
    }

    public String generateLDNMessage() {
        ConfigurationService config = DSpaceServicesFactory.getInstance().getConfigurationService();
        VelocityEngine templateEngine = new VelocityEngine();
        templateEngine.init(VELOCITY_PROPERTIES);
        VelocityContext vctx = new VelocityContext();
        vctx.put("config", (Object)new UnmodifiableConfigurationService(config));
        vctx.put("params", Collections.unmodifiableList(this.arguments));
        if (null == this.template) {
            if (StringUtils.isBlank((CharSequence)this.content)) {
                LOG.error("template has no content");
                throw new RuntimeException("template has no content");
            }
            StringResourceRepository repo = (StringResourceRepository)templateEngine.getApplicationAttribute((Object)RESOURCE_REPOSITORY_NAME);
            repo.putStringResource(this.contentName, this.content);
            this.template = templateEngine.getTemplate(this.contentName);
        }
        StringWriter writer = new StringWriter();
        try {
            this.template.merge((Context)vctx, (Writer)writer);
        }
        catch (MethodInvocationException | ParseErrorException | ResourceNotFoundException ex) {
            LOG.error("Template not merged:  {}", (Object)ex.getMessage());
            throw new RuntimeException("Template not merged", ex);
        }
        return writer.toString();
    }

    public static LDN getLDNMessage(String ldnMessageFile) throws IOException {
        StringBuilder contentBuffer = new StringBuilder();
        try (FileInputStream is = new FileInputStream(ldnMessageFile);
             InputStreamReader ir = new InputStreamReader((InputStream)is, "UTF-8");
             BufferedReader reader = new BufferedReader(ir);){
            boolean more = true;
            while (more) {
                String line = reader.readLine();
                if (line == null) {
                    more = false;
                    continue;
                }
                contentBuffer.append(line);
                contentBuffer.append("\n");
            }
        }
        LDN ldn = new LDN();
        ldn.setContent(ldnMessageFile, contentBuffer.toString());
        return ldn;
    }

    static {
        VELOCITY_PROPERTIES.put("resource.loaders", "string");
        VELOCITY_PROPERTIES.put("resource.loader.string.description", "Velocity StringResource loader");
        VELOCITY_PROPERTIES.put("resource.loader.string.class", StringResourceLoader.class.getName());
        VELOCITY_PROPERTIES.put("resource.loader.string.repository.name", RESOURCE_REPOSITORY_NAME);
        VELOCITY_PROPERTIES.put("resource.loader.string.repository.static", "false");
    }

    public static class UnmodifiableConfigurationService {
        private final ConfigurationService configurationService;

        public UnmodifiableConfigurationService(ConfigurationService cs) {
            this.configurationService = cs;
        }

        public String get(String key) {
            return this.configurationService.getProperty(key);
        }
    }
}

