/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.logic.condition;

import java.sql.SQLException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.logic.LogicalStatementException;
import org.dspace.content.logic.condition.AbstractCondition;
import org.dspace.core.Context;

public class InCollectionCondition
extends AbstractCondition {
    private static Logger log = LogManager.getLogger(InCollectionCondition.class);

    @Override
    public boolean getResult(Context context, Item item) throws LogicalStatementException {
        List collectionHandles = (List)this.getParameters().get("collections");
        List<Collection> itemCollections = item.getCollections();
        for (Collection collection : itemCollections) {
            if (!collectionHandles.contains(collection.getHandle())) continue;
            log.debug("item " + item.getHandle() + " is in collection " + collection.getHandle() + ", returning true");
            return true;
        }
        try {
            DSpaceObject parent = this.itemService.getParentObject(context, item);
            if (parent != null) {
                log.debug("Got parent DSO for item: " + parent.getID().toString());
                log.debug("Parent DSO handle: " + parent.getHandle());
                if (collectionHandles.contains(parent.getHandle())) {
                    log.debug("item " + item.getHandle() + " is in collection " + parent.getHandle() + ", returning true");
                    return true;
                }
            } else {
                log.debug("Parent DSO is null...");
            }
        }
        catch (SQLException e) {
            log.error("Error obtaining parent DSO", (Throwable)e);
            throw new LogicalStatementException(e);
        }
        log.debug("item " + item.getHandle() + " not found in the passed collection handle list");
        return false;
    }
}

