/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataFieldName;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataSchemaEnum;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkMetadataValidator;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.core.factory.CoreServiceFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;

public class XSLTIngestionCrosswalk
extends XSLTCrosswalk
implements IngestionCrosswalk {
    private static final Logger log = LogManager.getLogger(XSLTIngestionCrosswalk.class);
    private static final String DIRECTION = "submission";
    private static final String[] aliases = XSLTIngestionCrosswalk.makeAliases("submission");
    private static final CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private static final CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private static final ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public static String[] getPluginNames() {
        return (String[])ArrayUtils.clone((Object[])aliases);
    }

    private static void applyDim(Context context, List<Element> dimList, Item item, boolean createMissingMetadataFields) throws CrosswalkException, SQLException, AuthorizeException {
        for (Element elt : dimList) {
            if ("field".equals(elt.getName()) && DIM_NS.equals((Object)elt.getNamespace())) {
                XSLTIngestionCrosswalk.applyDimField(context, elt, item, createMissingMetadataFields);
                continue;
            }
            if ("dim".equals(elt.getName()) && DIM_NS.equals((Object)elt.getNamespace())) {
                XSLTIngestionCrosswalk.applyDim(context, elt.getChildren(), item, createMissingMetadataFields);
                continue;
            }
            log.error("Got unexpected element in DIM list: " + elt.toString());
            throw new MetadataValidationException("Got unexpected element in DIM list: " + elt.toString());
        }
    }

    private static void applyDimField(Context context, Element field, Item item, boolean createMissingMetadataFields) throws CrosswalkException, SQLException, AuthorizeException {
        String schema = field.getAttributeValue("mdschema");
        String element = field.getAttributeValue("element");
        String qualifier = field.getAttributeValue("qualifier");
        String lang = field.getAttributeValue("lang");
        String authority = field.getAttributeValue("authority");
        String sconf = field.getAttributeValue("confidence");
        CrosswalkMetadataValidator metadataValidator = new CrosswalkMetadataValidator();
        MetadataField metadataField = metadataValidator.checkMetadata(context, schema, element, qualifier, createMissingMetadataFields);
        if (qualifier != null && qualifier.equals("")) {
            qualifier = null;
        }
        if (authority != null && authority.length() > 0 || sconf != null && sconf.length() > 0) {
            int confidence = sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : -1;
            itemService.addMetadata(context, item, metadataField, lang, field.getText(), authority, confidence);
        } else {
            itemService.addMetadata(context, item, metadataField, lang, field.getText());
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, List<Element> metadata, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Transformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            JDOMResult result = new JDOMResult();
            xform.transform((Source)new JDOMSource(metadata), (Result)result);
            List contentList = result.getResult();
            List<Element> elementList = contentList.stream().filter(obj -> obj instanceof Element).map(Element.class::cast).collect(Collectors.toList());
            XSLTIngestionCrosswalk.ingestDIM(context, dso, elementList, createMissingMetadataFields);
        }
        catch (TransformerException e) {
            log.error("Got error: " + e.toString());
            throw new CrosswalkInternalException("XSL Transformation failed: " + e.toString(), e);
        }
    }

    @Override
    public void ingest(Context context, DSpaceObject dso, Element root, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Transformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            JDOMSource source = new JDOMSource(new Document(root.clone()));
            JDOMResult result = new JDOMResult();
            xform.transform((Source)source, (Result)result);
            Document dimDoc = result.getDocument();
            XSLTIngestionCrosswalk.ingestDIM(context, dso, dimDoc.getRootElement().getChildren(), createMissingMetadataFields);
        }
        catch (TransformerException e) {
            log.error("Got error: " + e.toString());
            throw new CrosswalkInternalException("XSL Transformation failed: " + e.toString(), e);
        }
    }

    private static MetadataFieldName getMetadataForDIM(Element field) {
        String element = field.getAttributeValue("element");
        String qualifier = field.getAttributeValue("qualifier");
        return new MetadataFieldName(MetadataSchemaEnum.DC.getName(), element, qualifier);
    }

    public static void ingestDIM(Context context, DSpaceObject dso, Element dim, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        XSLTIngestionCrosswalk.ingestDIM(context, dso, dim.getChildren(), createMissingMetadataFields);
    }

    public static void ingestDIM(Context context, DSpaceObject dso, List<Element> fields, boolean createMissingMetadataFields) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        int type = dso.getType();
        if (type == 2) {
            Item item = (Item)dso;
            XSLTIngestionCrosswalk.applyDim(context, fields, item, createMissingMetadataFields);
        } else if (type == 3 || type == 4) {
            for (Element field : fields) {
                String schema = field.getAttributeValue("mdschema");
                if ("dim".equals(field.getName()) && DIM_NS.equals((Object)field.getNamespace())) {
                    XSLTIngestionCrosswalk.ingestDIM(context, dso, field.getChildren(), createMissingMetadataFields);
                    continue;
                }
                if ("field".equals(field.getName()) && DIM_NS.equals((Object)field.getNamespace()) && schema != null && "dc".equals(schema)) {
                    MetadataFieldName md = XSLTIngestionCrosswalk.getMetadataForDIM(field);
                    if (md == null) {
                        log.warn("Cannot map to Coll/Comm metadata field, DIM element=" + field.getAttributeValue("element") + ", qualifier=" + field.getAttributeValue("qualifier"));
                        continue;
                    }
                    if (type == 3) {
                        collectionService.setMetadataSingleValue(context, (Collection)dso, md, null, field.getText());
                        continue;
                    }
                    communityService.setMetadataSingleValue(context, (Community)dso, md, null, field.getText());
                    continue;
                }
                log.warn("ignoring unrecognized DIM element: " + field.toString());
            }
        } else {
            throw new CrosswalkObjectNotSupported("XsltSubmissionionCrosswalk can only crosswalk to an Item.");
        }
    }

    public static void main(String[] argv) throws Exception {
        List dimList;
        Transformer xform;
        IngestionCrosswalk xwalk;
        if (argv.length < 2) {
            System.err.println("Usage:  java XSLTIngestionCrosswalk [-l] <crosswalk-name> <input-file>");
            System.exit(1);
        }
        int i = 0;
        boolean list = false;
        if (argv.length > 2 && argv[0].equals("-l")) {
            ++i;
            list = true;
        }
        if ((xwalk = (IngestionCrosswalk)CoreServiceFactory.getInstance().getPluginService().getNamedPlugin(IngestionCrosswalk.class, argv[i])) == null) {
            System.err.println("Error, cannot find an IngestionCrosswalk plugin for: \"" + argv[i] + "\"");
            System.exit(1);
        }
        if ((xform = ((XSLTIngestionCrosswalk)xwalk).getTransformer(DIRECTION)) == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        SAXBuilder builder = XMLUtils.getSAXBuilder();
        Document inDoc = builder.build((InputStream)new FileInputStream(argv[i + 1]));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        if (list) {
            source = new JDOMSource(inDoc.getRootElement().getChildren());
            result = new JDOMResult();
            xform.transform((Source)source, (Result)result);
            dimList = result.getResult();
            outputter.output(dimList, (OutputStream)System.out);
        } else {
            source = new JDOMSource(inDoc);
            result = new JDOMResult();
            xform.transform((Source)source, (Result)result);
            Document dimDoc = result.getDocument();
            outputter.output(dimDoc, (OutputStream)System.out);
            dimList = dimDoc.getRootElement().getChildren();
        }
        Context context = new Context();
        for (Object o : dimList) {
            if (!(o instanceof Element)) continue;
            Element elt = (Element)o;
            if (elt.getName().equals("field") && elt.getNamespace().equals((Object)DIM_NS)) {
                MetadataField mf;
                String schema = elt.getAttributeValue("mdschema");
                String element = elt.getAttributeValue("element");
                String qualifier = elt.getAttributeValue("qualifier");
                MetadataSchema ms = ContentServiceFactory.getInstance().getMetadataSchemaService().find(context, schema);
                if (ms == null) {
                    System.err.println("DIM Error, Cannot find metadata schema for: schema=\"" + schema + "\" (... element=\"" + element + "\", qualifier=\"" + qualifier + "\")");
                    continue;
                }
                if (qualifier != null && qualifier.equals("")) {
                    System.err.println("DIM Warning, qualifier is empty string:  schema=\"" + schema + "\", element=\"" + element + "\", qualifier=\"" + qualifier + "\"");
                    qualifier = null;
                }
                if ((mf = ContentServiceFactory.getInstance().getMetadataFieldService().findByElement(context, ms, element, qualifier)) != null) continue;
                System.err.println("DIM Error, Cannot find metadata field for: schema=\"" + schema + "\", element=\"" + element + "\", qualifier=\"" + qualifier + "\"");
                continue;
            }
            throw new MetadataValidationException("Got unexpected element in DIM list: " + elt.toString());
        }
        context.complete();
    }
}

