/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.StreamIngestionCrosswalk;
import org.dspace.core.Context;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;

public class CreativeCommonsRDFStreamIngestionCrosswalk
implements StreamIngestionCrosswalk {
    private static Logger log = LogManager.getLogger(CreativeCommonsRDFStreamIngestionCrosswalk.class);
    protected CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();

    @Override
    public void ingest(Context context, DSpaceObject dso, InputStream in, String MIMEType) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() == 2) {
            if (log.isDebugEnabled()) {
                log.debug("Reading a Creative Commons license, MIMEtype=" + MIMEType);
            }
            this.creativeCommonsService.setLicense(context, (Item)dso, in, MIMEType);
        }
    }

    public String getMIMEType() {
        return "text/rdf";
    }
}

