/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker.dao.impl;

import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.criteria.Subquery;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.dspace.checker.ChecksumHistory;
import org.dspace.checker.ChecksumHistory_;
import org.dspace.checker.ChecksumResultCode;
import org.dspace.checker.ChecksumResult_;
import org.dspace.checker.MostRecentChecksum;
import org.dspace.checker.MostRecentChecksum_;
import org.dspace.checker.dao.MostRecentChecksumDAO;
import org.dspace.content.Bitstream;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class MostRecentChecksumDAOImpl
extends AbstractHibernateDAO<MostRecentChecksum>
implements MostRecentChecksumDAO {
    protected MostRecentChecksumDAOImpl() {
    }

    @Override
    public List<MostRecentChecksum> findByNotProcessedInDateRange(Context context, Date startDate, Date endDate) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MostRecentChecksum> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MostRecentChecksum.class);
        Root mostRecentChecksumRoot = criteriaQuery.from(MostRecentChecksum.class);
        criteriaQuery.select((Selection)mostRecentChecksumRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.toBeProcessed), (Object)false), criteriaBuilder.lessThanOrEqualTo((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processStartDate), (Comparable)startDate), criteriaBuilder.greaterThan((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processStartDate), (Comparable)endDate)}));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.bitstream)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, MostRecentChecksum.class, -1, -1);
    }

    @Override
    public MostRecentChecksum findByBitstream(Context context, Bitstream bitstream) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MostRecentChecksum> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MostRecentChecksum.class);
        Root mostRecentChecksumRoot = criteriaQuery.from(MostRecentChecksum.class);
        criteriaQuery.select((Selection)mostRecentChecksumRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.bitstream), (Object)bitstream));
        return (MostRecentChecksum)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<MostRecentChecksum> findByResultTypeInDateRange(Context context, Date startDate, Date endDate, ChecksumResultCode resultCode) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MostRecentChecksum> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MostRecentChecksum.class);
        Root mostRecentChecksumRoot = criteriaQuery.from(MostRecentChecksum.class);
        Join mostRecentResult = mostRecentChecksumRoot.join(MostRecentChecksum_.checksumResult);
        criteriaQuery.select((Selection)mostRecentChecksumRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and(new Predicate[]{criteriaBuilder.equal((Expression)mostRecentResult.get(ChecksumResult_.resultCode), (Object)resultCode), criteriaBuilder.lessThanOrEqualTo((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processStartDate), (Comparable)endDate), criteriaBuilder.greaterThan((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processStartDate), (Comparable)startDate)}));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.bitstream)));
        criteriaQuery.orderBy(orderList);
        return this.list(context, criteriaQuery, false, MostRecentChecksum.class, -1, -1);
    }

    @Override
    public void deleteByBitstream(Context context, Bitstream bitstream) throws SQLException {
        String hql = "delete from MostRecentChecksum WHERE bitstream=:bitstream";
        Query query = this.createQuery(context, hql);
        query.setParameter("bitstream", (Object)bitstream);
        query.executeUpdate();
    }

    @Override
    public MostRecentChecksum getOldestRecord(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MostRecentChecksum> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MostRecentChecksum.class);
        Root mostRecentChecksumRoot = criteriaQuery.from(MostRecentChecksum.class);
        criteriaQuery.select((Selection)mostRecentChecksumRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.toBeProcessed), (Object)true));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processEndDate)));
        orderList.add(criteriaBuilder.asc((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.bitstream)));
        criteriaQuery.orderBy(orderList);
        return (MostRecentChecksum)this.singleResult(context, criteriaQuery);
    }

    @Override
    public MostRecentChecksum getOldestRecord(Context context, Date lessThanDate) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MostRecentChecksum> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MostRecentChecksum.class);
        Root mostRecentChecksumRoot = criteriaQuery.from(MostRecentChecksum.class);
        criteriaQuery.select((Selection)mostRecentChecksumRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.toBeProcessed), (Object)true), (Expression)criteriaBuilder.lessThan((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processStartDate), (Comparable)lessThanDate)));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.processEndDate)));
        orderList.add(criteriaBuilder.asc((Expression)mostRecentChecksumRoot.get(MostRecentChecksum_.bitstream)));
        criteriaQuery.orderBy(orderList);
        return (MostRecentChecksum)this.singleResult(context, criteriaQuery);
    }

    @Override
    public List<MostRecentChecksum> findNotInHistory(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<MostRecentChecksum> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, MostRecentChecksum.class);
        Root checksumRoot = criteriaQuery.from(MostRecentChecksum.class);
        Subquery subQuery = criteriaQuery.subquery(Bitstream.class);
        Root historyRoot = subQuery.from(ChecksumHistory.class);
        subQuery.select((Expression)historyRoot.get(ChecksumHistory_.bitstream));
        criteriaQuery.where((Expression)criteriaBuilder.not((Expression)checksumRoot.get(MostRecentChecksum_.bitstream).in(new Expression[]{subQuery})));
        return this.list(context, criteriaQuery, false, MostRecentChecksum.class, -1, -1);
    }
}

