/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class RegexPatternUtils {
    public static final String REGEX_INPUT_VALIDATOR = "(/?)(.+)\\1([gimsuy]*)";
    public static final String REGEX_FLAGS = "(?%s)";
    public static final Pattern PATTERN_REGEX_INPUT_VALIDATOR = Pattern.compile("(/?)(.+)\\1([gimsuy]*)", 2);

    public static final Pattern computePattern(String regex) throws PatternSyntaxException {
        if (StringUtils.isBlank((CharSequence)regex)) {
            return null;
        }
        Matcher inputMatcher = PATTERN_REGEX_INPUT_VALIDATOR.matcher(regex);
        String regexPattern = regex;
        String regexFlags = "";
        if (inputMatcher.matches()) {
            regexPattern = Optional.of(inputMatcher.group(2)).filter(StringUtils::isNotBlank).orElse(regex);
            regexFlags = Optional.ofNullable(inputMatcher.group(3)).filter(StringUtils::isNotBlank).map(flags -> String.format(REGEX_FLAGS, flags)).orElse("").replaceAll("g", "");
        }
        return Pattern.compile(regexFlags + regexPattern);
    }

    private RegexPatternUtils() {
    }
}

