/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.suggestion.openaire;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.suggestion.openaire.PublicationLoader;
import org.dspace.app.suggestion.openaire.PublicationLoaderScriptConfiguration;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.SearchService;
import org.dspace.discovery.SearchServiceException;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.utils.DiscoverQueryBuilder;
import org.dspace.discovery.utils.parameter.QueryBuilderSearchFilter;
import org.dspace.scripts.DSpaceRunnable;
import org.dspace.utils.DSpace;

public class PublicationLoaderRunnable
extends DSpaceRunnable<PublicationLoaderScriptConfiguration<PublicationLoaderRunnable>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private PublicationLoader oairePublicationLoader = null;
    protected Context context;
    protected String profile;

    @Override
    public PublicationLoaderScriptConfiguration<PublicationLoaderRunnable> getScriptConfiguration() {
        PublicationLoaderScriptConfiguration configuration = (PublicationLoaderScriptConfiguration)new DSpace().getServiceManager().getServiceByName("import-openaire-suggestions", PublicationLoaderScriptConfiguration.class);
        return configuration;
    }

    @Override
    public void setup() throws ParseException {
        this.oairePublicationLoader = (PublicationLoader)new DSpace().getServiceManager().getServiceByName("OpenairePublicationLoader", PublicationLoader.class);
        this.profile = this.commandLine.getOptionValue("s");
        if (this.profile == null) {
            LOGGER.info("No argument for -s, process all profiles");
        } else {
            LOGGER.info("Process eperson item with UUID {}", (Object)this.profile);
        }
    }

    @Override
    public void internalRun() throws Exception {
        this.context = new Context();
        Iterator<Item> researchers = this.getResearchers(this.profile);
        while (researchers.hasNext()) {
            Item researcher = researchers.next();
            this.oairePublicationLoader.importAuthorRecords(this.context, researcher);
        }
    }

    private Iterator<Item> getResearchers(String profileUUID) {
        SearchService searchService = (SearchService)new DSpace().getSingletonService(SearchService.class);
        DiscoverQueryBuilder queryBuilder = SearchUtils.getQueryBuilder();
        ArrayList<QueryBuilderSearchFilter> filters = new ArrayList<QueryBuilderSearchFilter>();
        Object query = "*:*";
        if (profileUUID != null) {
            query = "search.resourceid:" + profileUUID;
        }
        try {
            DiscoverQuery discoverQuery = queryBuilder.buildQuery(this.context, null, SearchUtils.getDiscoveryConfigurationByName("person"), (String)query, filters, "Item", (Integer)10, Long.getLong("0"), null, "DESC");
            return searchService.iteratorSearch(this.context, null, discoverQuery);
        }
        catch (SearchServiceException e) {
            LOGGER.error("Unable to read researcher on solr", (Throwable)e);
            return null;
        }
    }
}

