/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.app.statistics.Report;
import org.dspace.app.statistics.ReportTools;
import org.dspace.app.statistics.Stat;
import org.dspace.app.statistics.Statistics;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class HTMLReport
implements Report {
    private final List<Statistics> blocks = new ArrayList<Statistics>();
    private String pageTitle = null;
    private String mainTitle = null;
    private Date start = null;
    private Date end = null;
    private String output;

    public HTMLReport() {
        ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();
        this.output = configurationService.getProperty("dspace.dir") + File.separator + "log" + File.separator + "report";
    }

    public void setOutput(String newOutput) {
        if (newOutput != null) {
            this.output = newOutput;
        }
    }

    @Override
    public String render() {
        StringBuilder frag = new StringBuilder();
        frag.append(this.header(this.pageTitle));
        frag.append(this.mainTitle());
        frag.append(this.dateRange());
        Iterator<Statistics> statSets = this.blocks.iterator();
        while (statSets.hasNext()) {
            frag.append(this.navigation());
            Statistics stats = statSets.next();
            frag.append(this.sectionHeader(stats.getSectionHeader()));
            frag.append(this.topLink());
            frag.append(this.blockExplanation(stats.getExplanation()));
            frag.append(this.floorInfo(stats.getFloor()));
            frag.append(this.statBlock(stats));
        }
        frag.append(this.footer());
        try {
            FileOutputStream fos = new FileOutputStream(this.output);
            OutputStreamWriter osr = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            PrintWriter out = new PrintWriter(osr);
            out.write(frag.toString());
            out.close();
        }
        catch (IOException e) {
            System.out.println("Unable to write to output file " + this.output);
            System.exit(0);
        }
        return frag.toString();
    }

    public String topLink() {
        return "<div class=\"reportNavigation\"><a href=\"#top\">Top</a></div>";
    }

    public String navigation() {
        StringBuilder frag = new StringBuilder();
        frag.append("<div class=\"reportNavigation\">");
        frag.append("<a href=\"#general_overview\">General Overview</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#archive_information\">Archive Information</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#items_viewed\">Items Viewed</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#all_actions_performed\">All Actions Performed</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#user_logins\">User Logins</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#words_searched\">Words Searched</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#averaging_information\">Averaging Information</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#log_level_information\">Log Level Information</a>");
        frag.append("&nbsp;|&nbsp;");
        frag.append("<a href=\"#processing_information\">Processing Information</a>");
        frag.append("</div>");
        return frag.toString();
    }

    @Override
    public void addBlock(Statistics stat) {
        this.blocks.add(stat);
    }

    @Override
    public void setStartDate(Date start) {
        this.start = start == null ? null : new Date(start.getTime());
    }

    @Override
    public void setEndDate(Date end) {
        this.end = end == null ? null : new Date(end.getTime());
    }

    @Override
    public String dateRange() {
        StringBuilder frag = new StringBuilder();
        DateFormat df = DateFormat.getDateInstance();
        frag.append("<div class=\"reportDate\">");
        if (this.start != null) {
            frag.append(df.format(this.start));
        } else {
            frag.append("from start of records ");
        }
        frag.append(" to ");
        if (this.end != null) {
            frag.append(df.format(this.end));
        } else {
            frag.append(" end of records");
        }
        frag.append("</div>\n\n");
        return frag.toString();
    }

    @Override
    public String mainTitle() {
        return "<div class=\"reportTitle\"><a name=\"top\">" + this.mainTitle + "</a></div>\n\n";
    }

    @Override
    public void setMainTitle(String name, String serverName) {
        this.mainTitle = "Statistics for " + name + " on " + serverName;
        if (this.pageTitle == null) {
            this.pageTitle = this.mainTitle;
        }
    }

    @Override
    public String header() {
        return this.header("");
    }

    @Override
    public String header(String title) {
        StringBuilder frag = new StringBuilder();
        frag.append("<style type=\"text/css\">\n");
        frag.append("body { font-family: Arial, Helvetica, sans-serif }");
        frag.append(".reportTitle { width: 100%; clear: both; text-align: center; font-weight: bold; font-size: 200%; margin: 20px; }\n");
        frag.append(".reportSection { width: 100%; clear: both; font-weight: bold; font-size: 160%; margin: 10px; text-align: center; margin-top: 30px; }\n");
        frag.append(".reportBlock { border: 1px solid #000000; margin: 10px; }\n");
        frag.append(".reportOddRow { background: #dddddd; }\n");
        frag.append(".reportEvenRow { background: #bbbbbb; }\n");
        frag.append(".reportExplanation { font-style: italic; text-align: center; }\n");
        frag.append(".reportDate { font-style: italic; text-align: center; font-size: 120% }\n");
        frag.append(".reportFloor { text-align: center; }\n");
        frag.append(".rightAlign { text-align: right; }\n");
        frag.append(".reportNavigation { text-align: center; }\n");
        frag.append("</style>\n");
        return frag.toString();
    }

    @Override
    public String sectionHeader(String title) {
        String aName = title.toLowerCase();
        Pattern space = Pattern.compile(" ");
        Matcher matchSpace = space.matcher(aName);
        aName = matchSpace.replaceAll("_");
        return "<div class=\"reportSection\"><a name=\"" + aName + "\">" + title + "</a></div>\n\n";
    }

    @Override
    public String statBlock(Statistics content) {
        StringBuilder frag = new StringBuilder();
        Stat[] stats = content.getStats();
        frag.append("<table align=\"center\" class=\"reportBlock\" cellpadding=\"5\">\n");
        if (content.getStatName() != null || content.getResultName() != null) {
            frag.append("\t<tr>\n");
            frag.append("\t\t<th>\n");
            if (content.getStatName() != null) {
                frag.append("\t\t\t").append(content.getStatName()).append("\n");
            } else {
                frag.append("\t\t\t&nbsp;\n");
            }
            frag.append("\t\t</th>\n");
            frag.append("\t\t<th>\n");
            if (content.getResultName() != null) {
                frag.append("\t\t\t").append(content.getResultName()).append("\n");
            } else {
                frag.append("\t\t\t&nbsp;\n");
            }
            frag.append("\t\t</th>\n");
            frag.append("\t</tr>\n");
        }
        for (int i = 0; i < stats.length; ++i) {
            String style = null;
            style = (i & 1) == 1 ? "reportOddRow" : "reportEvenRow";
            frag.append("\t<tr class=\"").append(style).append("\">\n\t\t<td>\n");
            frag.append("\t\t\t");
            if (stats[i].getReference() != null) {
                frag.append("<a href=\"").append(stats[i].getReference()).append("\" ");
                frag.append("target=\"_blank\">");
            }
            frag.append(this.clean(stats[i].getKey()));
            if (stats[i].getReference() != null) {
                frag.append("</a>");
            }
            frag.append("\n");
            frag.append("\t\t</td>\n\t\t<td class=\"rightAlign\">\n");
            frag.append("\t\t\t").append(ReportTools.numberFormat(stats[i].getValue()));
            if (stats[i].getUnits() != null) {
                frag.append(" ").append(stats[i].getUnits());
            }
            frag.append("\n");
            frag.append("\t\t</td>\n\t</tr>\n");
        }
        frag.append("</table>\n");
        return frag.toString();
    }

    @Override
    public String floorInfo(int floor) {
        if (floor > 0) {
            StringBuilder frag = new StringBuilder();
            frag.append("<div class=\"reportFloor\">");
            frag.append("(more than ").append(ReportTools.numberFormat(floor)).append(" times)");
            frag.append("</div>\n");
            return frag.toString();
        }
        return "";
    }

    @Override
    public String blockExplanation(String explanation) {
        if (explanation != null) {
            StringBuilder frag = new StringBuilder();
            frag.append("<div class=\"reportExplanation\">");
            frag.append(explanation);
            frag.append("</div>\n\n");
            return frag.toString();
        }
        return "";
    }

    @Override
    public String footer() {
        return "";
    }

    private String clean(String s) {
        s = s.replace("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        return s;
    }
}

