/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.dao.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ListJoin;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.List;
import org.dspace.app.ldn.NotifyServiceEntity;
import org.dspace.app.ldn.NotifyServiceEntity_;
import org.dspace.app.ldn.NotifyServiceInboundPattern_;
import org.dspace.app.ldn.dao.NotifyServiceDao;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class NotifyServiceDaoImpl
extends AbstractHibernateDAO<NotifyServiceEntity>
implements NotifyServiceDao {
    @Override
    public NotifyServiceEntity findByLdnUrl(Context context, String ldnUrl) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<NotifyServiceEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, NotifyServiceEntity.class);
        Root notifyServiceEntityRoot = criteriaQuery.from(NotifyServiceEntity.class);
        criteriaQuery.select((Selection)notifyServiceEntityRoot);
        criteriaQuery.where((Expression)criteriaBuilder.equal((Expression)notifyServiceEntityRoot.get(NotifyServiceEntity_.ldnUrl), (Object)ldnUrl));
        return this.uniqueResult(context, criteriaQuery, false, NotifyServiceEntity.class);
    }

    @Override
    public List<NotifyServiceEntity> findManualServicesByInboundPattern(Context context, String pattern) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<NotifyServiceEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, NotifyServiceEntity.class);
        Root notifyServiceEntityRoot = criteriaQuery.from(NotifyServiceEntity.class);
        ListJoin notifyServiceInboundPatternJoin = notifyServiceEntityRoot.join(NotifyServiceEntity_.inboundPatterns);
        criteriaQuery.select((Selection)notifyServiceEntityRoot);
        criteriaQuery.where((Expression)criteriaBuilder.and((Expression)criteriaBuilder.equal((Expression)notifyServiceInboundPatternJoin.get(NotifyServiceInboundPattern_.pattern), (Object)pattern), (Expression)criteriaBuilder.equal((Expression)notifyServiceInboundPatternJoin.get(NotifyServiceInboundPattern_.automatic), (Object)false)));
        return this.list(context, criteriaQuery, false, NotifyServiceEntity.class, -1, -1);
    }
}

