/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.ldn.dao.impl;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.ldn.LDNMessageEntity;
import org.dspace.app.ldn.LDNMessageEntity_;
import org.dspace.app.ldn.dao.LDNMessageDao;
import org.dspace.content.Item;
import org.dspace.core.AbstractHibernateDAO;
import org.dspace.core.Context;

public class LDNMessageDaoImpl
extends AbstractHibernateDAO<LDNMessageEntity>
implements LDNMessageDao {
    private static final Logger log = LogManager.getLogger(LDNMessageDaoImpl.class);

    @Override
    public List<LDNMessageEntity> findOldestMessageToProcess(Context context, int max_attempts) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<LDNMessageEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, LDNMessageEntity.class);
        Root root = criteriaQuery.from(LDNMessageEntity.class);
        criteriaQuery.select((Selection)root);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(3);
        andPredicates.add(criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.queueStatus), (Object)LDNMessageEntity.QUEUE_STATUS_QUEUED));
        andPredicates.add(criteriaBuilder.lessThan((Expression)root.get(LDNMessageEntity_.queueAttempts), (Comparable)Integer.valueOf(max_attempts)));
        andPredicates.add(criteriaBuilder.lessThan((Expression)root.get(LDNMessageEntity_.queueTimeout), (Comparable)new Date()));
        criteriaQuery.where((Expression)criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)root.get(LDNMessageEntity_.queueAttempts)));
        orderList.add(criteriaBuilder.asc((Expression)root.get(LDNMessageEntity_.queueLastStartTime)));
        criteriaQuery.orderBy(orderList);
        List<LDNMessageEntity> result = this.list(context, criteriaQuery, false, LDNMessageEntity.class, -1, -1);
        if (result == null || result.isEmpty()) {
            log.debug("No LDN messages found to be processed");
        }
        return result;
    }

    @Override
    public List<LDNMessageEntity> findMessagesToBeReprocessed(Context context) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<LDNMessageEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, LDNMessageEntity.class);
        Root root = criteriaQuery.from(LDNMessageEntity.class);
        criteriaQuery.select((Selection)root);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(1);
        andPredicates.add(criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.queueStatus), (Object)LDNMessageEntity.QUEUE_STATUS_QUEUED_FOR_RETRY));
        criteriaQuery.where((Expression)criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)root.get(LDNMessageEntity_.queueAttempts)));
        orderList.add(criteriaBuilder.asc((Expression)root.get(LDNMessageEntity_.queueLastStartTime)));
        criteriaQuery.orderBy(orderList);
        List<LDNMessageEntity> result = this.list(context, criteriaQuery, false, LDNMessageEntity.class, -1, -1);
        if (result == null || result.isEmpty()) {
            log.debug("No LDN messages found to be processed");
        }
        return result;
    }

    @Override
    public List<LDNMessageEntity> findProcessingTimedoutMessages(Context context, int max_attempts) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<LDNMessageEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, LDNMessageEntity.class);
        Root root = criteriaQuery.from(LDNMessageEntity.class);
        criteriaQuery.select((Selection)root);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>(3);
        andPredicates.add(criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.queueStatus), (Object)LDNMessageEntity.QUEUE_STATUS_PROCESSING));
        andPredicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(LDNMessageEntity_.queueAttempts), (Comparable)Integer.valueOf(max_attempts)));
        andPredicates.add(criteriaBuilder.lessThan((Expression)root.get(LDNMessageEntity_.queueTimeout), (Comparable)new Date()));
        criteriaQuery.where((Expression)criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.desc((Expression)root.get(LDNMessageEntity_.queueAttempts)));
        orderList.add(criteriaBuilder.asc((Expression)root.get(LDNMessageEntity_.queueLastStartTime)));
        criteriaQuery.orderBy(orderList);
        List<LDNMessageEntity> result = this.list(context, criteriaQuery, false, LDNMessageEntity.class, -1, -1);
        if (result == null || result.isEmpty()) {
            log.debug("No LDN messages found to be processed");
        }
        return result;
    }

    @Override
    public List<LDNMessageEntity> findAllRelatedMessagesByItem(Context context, LDNMessageEntity msg, Item item, String ... relatedTypes) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<LDNMessageEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, LDNMessageEntity.class);
        Root root = criteriaQuery.from(LDNMessageEntity.class);
        criteriaQuery.select((Selection)root);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        Predicate relatedtypePredicate = null;
        andPredicates.add(criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.queueStatus), (Object)LDNMessageEntity.QUEUE_STATUS_PROCESSED));
        andPredicates.add(criteriaBuilder.isNull((Expression)root.get(LDNMessageEntity_.target)));
        andPredicates.add(criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.inReplyTo), (Object)msg));
        if (relatedTypes != null && relatedTypes.length > 0) {
            relatedtypePredicate = root.get(LDNMessageEntity_.activityStreamType).in((Object[])relatedTypes);
            andPredicates.add(relatedtypePredicate);
        }
        criteriaQuery.where((Expression)criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)root.get(LDNMessageEntity_.queueLastStartTime)));
        orderList.add(criteriaBuilder.desc((Expression)root.get(LDNMessageEntity_.queueAttempts)));
        criteriaQuery.orderBy(orderList);
        List<LDNMessageEntity> result = this.list(context, criteriaQuery, false, LDNMessageEntity.class, -1, -1);
        if (result == null || result.isEmpty()) {
            log.debug("No LDN messages ACK found to be processed");
        }
        return result;
    }

    @Override
    public List<LDNMessageEntity> findAllMessagesByItem(Context context, Item item, String ... activities) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<LDNMessageEntity> criteriaQuery = this.getCriteriaQuery(criteriaBuilder, LDNMessageEntity.class);
        Root root = criteriaQuery.from(LDNMessageEntity.class);
        criteriaQuery.select((Selection)root);
        ArrayList<Predicate> andPredicates = new ArrayList<Predicate>();
        Predicate activityPredicate = null;
        andPredicates.add(criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.queueStatus), (Object)LDNMessageEntity.QUEUE_STATUS_PROCESSED));
        andPredicates.add(criteriaBuilder.or((Expression)criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.object), (Object)item), (Expression)criteriaBuilder.equal((Expression)root.get(LDNMessageEntity_.context), (Object)item)));
        if (activities != null && activities.length > 0) {
            activityPredicate = root.get(LDNMessageEntity_.activityStreamType).in((Object[])activities);
            andPredicates.add(activityPredicate);
        }
        criteriaQuery.where((Expression)criteriaBuilder.and(andPredicates.toArray(new Predicate[0])));
        LinkedList<Order> orderList = new LinkedList<Order>();
        orderList.add(criteriaBuilder.asc((Expression)root.get(LDNMessageEntity_.queueLastStartTime)));
        orderList.add(criteriaBuilder.desc((Expression)root.get(LDNMessageEntity_.queueAttempts)));
        criteriaQuery.orderBy(orderList);
        List<LDNMessageEntity> result = this.list(context, criteriaQuery, false, LDNMessageEntity.class, -1, -1);
        if (result == null || result.isEmpty()) {
            log.debug("No LDN messages found");
        }
        return result;
    }
}

