/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemupdate;

import java.sql.SQLException;
import java.util.List;
import org.dspace.app.itemupdate.DtoMetadata;
import org.dspace.app.itemupdate.ItemArchive;
import org.dspace.app.itemupdate.ItemUpdate;
import org.dspace.app.itemupdate.UpdateMetadataAction;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;

public class AddMetadataAction
extends UpdateMetadataAction {
    protected MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    protected MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();

    @Override
    public void execute(Context context, ItemArchive itarch, boolean isTest, boolean suppressUndo) throws AuthorizeException, SQLException {
        Item item = itarch.getItem();
        String dirname = itarch.getDirectoryName();
        block0: for (DtoMetadata dtom : itarch.getMetadataFields()) {
            for (String f : this.targetFields) {
                if (!dtom.matches(f, false)) continue;
                List<MetadataValue> ardcv = null;
                ardcv = itemService.getMetadata(item, dtom.schema, dtom.element, dtom.qualifier, "*");
                boolean found = false;
                for (MetadataValue dcv : ardcv) {
                    if (!dcv.getValue().equals(dtom.value)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    ItemUpdate.pr("Warning:  No new metadata found to add to item " + dirname + " for element " + f);
                    continue block0;
                }
                if (isTest) {
                    ItemUpdate.pr("Metadata to add: " + dtom.toString());
                    MetadataSchema foundSchema = this.metadataSchemaService.find(context, dtom.schema);
                    if (foundSchema == null) {
                        ItemUpdate.pr("ERROR: schema '" + dtom.schema + "' was not found in the registry; found on item " + dirname);
                        continue block0;
                    }
                    MetadataField foundField = this.metadataFieldService.findByElement(context, foundSchema, dtom.element, dtom.qualifier);
                    if (foundField != null) continue block0;
                    ItemUpdate.pr("ERROR: Metadata field: '" + dtom.schema + "." + dtom.element + "." + dtom.qualifier + "' not found in registry; found on item " + dirname);
                    continue block0;
                }
                itemService.addMetadata(context, item, dtom.schema, dtom.element, dtom.qualifier, dtom.language, dtom.value);
                ItemUpdate.pr("Metadata added: " + dtom.toString());
                if (suppressUndo) continue block0;
                for (MetadataValue dcval : ardcv) {
                    MetadataField metadataField = dcval.getMetadataField();
                    MetadataSchema metadataSchema = metadataField.getMetadataSchema();
                    itarch.addUndoMetadataField(DtoMetadata.create(metadataSchema.getName(), metadataField.getElement(), metadataField.getQualifier(), dcval.getLanguage(), dcval.getValue()));
                }
                continue block0;
            }
        }
    }
}

