/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.itemexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.dspace.app.itemexport.ItemExport;
import org.dspace.app.itemexport.service.ItemExportService;
import org.dspace.content.Item;
import org.dspace.core.Context;

public class ItemExportCLI
extends ItemExport {
    @Override
    protected void validate() {
        super.validate();
        this.setDestDirName();
        if (this.destDirName == null) {
            this.handler.logError("The destination directory must be set (run with -h flag for details)");
            throw new UnsupportedOperationException("The destination directory must be set");
        }
        if (this.seqStart == -1) {
            this.handler.logError("The sequence start number must be set (run with -h flag for details)");
            throw new UnsupportedOperationException("The sequence start number must be set");
        }
    }

    @Override
    protected void process(Context context, ItemExportService itemExportService) throws Exception {
        this.setZip(context);
        if (this.zip) {
            Iterator<Item> items;
            if (this.item != null) {
                ArrayList<Item> myItems = new ArrayList<Item>();
                myItems.add(this.item);
                items = myItems.iterator();
            } else {
                this.handler.logInfo("Exporting from collection: " + this.idString);
                items = itemService.findByCollection(context, this.collection);
            }
            itemExportService.exportAsZip(context, items, this.destDirName, this.zipFileName, this.seqStart, this.migrate, this.excludeBitstreams);
        } else if (this.item != null) {
            itemExportService.exportItem(context, Collections.singletonList(this.item).iterator(), this.destDirName, this.seqStart, this.migrate, this.excludeBitstreams);
        } else {
            this.handler.logInfo("Exporting from collection: " + this.idString);
            Iterator<Item> i = itemService.findByCollection(context, this.collection);
            itemExportService.exportItem(context, i, this.destDirName, this.seqStart, this.migrate, this.excludeBitstreams);
        }
    }

    protected void setDestDirName() {
        if (this.commandLine.hasOption('d')) {
            this.destDirName = this.commandLine.getOptionValue('d');
        }
    }

    @Override
    protected void setZip(Context context) {
        if (this.commandLine.hasOption('z')) {
            this.zip = true;
            this.zipFileName = this.commandLine.getOptionValue('z');
        }
    }

    @Override
    protected void setNumber() {
        if (this.commandLine.hasOption('n')) {
            this.seqStart = Integer.parseInt(this.commandLine.getOptionValue('n'));
        }
    }
}

