/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.checker;

import java.io.FileNotFoundException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.checker.BitstreamDispatcher;
import org.dspace.checker.CheckerCommand;
import org.dspace.checker.HandleDispatcher;
import org.dspace.checker.IteratorDispatcher;
import org.dspace.checker.LimitedCountDispatcher;
import org.dspace.checker.LimitedDurationDispatcher;
import org.dspace.checker.ResultsLogger;
import org.dspace.checker.ResultsPruner;
import org.dspace.checker.SimpleDispatcher;
import org.dspace.content.Bitstream;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.core.Context;
import org.dspace.core.Utils;

public final class ChecksumChecker {
    private static final Logger LOG = LogManager.getLogger(ChecksumChecker.class);
    private static final BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();

    private ChecksumChecker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws SQLException {
        DefaultParser parser = new DefaultParser();
        CommandLine line = null;
        Options options = new Options();
        options.addOption("l", "looping", false, "Loop once through bitstreams");
        options.addOption("L", "continuous", false, "Loop continuously through bitstreams");
        options.addOption("h", "help", false, "Help");
        options.addOption("d", "duration", true, "Checking duration");
        options.addOption("c", "count", true, "Check count");
        options.addOption("a", "handle", true, "Specify a handle to check");
        options.addOption("v", "verbose", false, "Report all processing");
        Option option = Option.builder((String)"b").longOpt("bitstream-ids").hasArgs().desc("Space separated list of bitstream ids").build();
        options.addOption(option);
        option = Option.builder((String)"p").longOpt("prune").optionalArg(true).desc("Prune old results (optionally using specified properties file for configuration)").build();
        options.addOption(option);
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.fatal((Object)e);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            ChecksumChecker.printHelp(options);
        }
        Context context = null;
        try {
            context = new Context();
            if (line.hasOption('p')) {
                ResultsPruner rp = null;
                try {
                    rp = line.getOptionValue('p') != null ? ResultsPruner.getPruner(context, line.getOptionValue('p')) : ResultsPruner.getDefaultPruner(context);
                }
                catch (FileNotFoundException e) {
                    LOG.error("File not found", (Throwable)e);
                    System.exit(1);
                }
                int count = rp.prune();
                System.out.println("Pruned " + count + " old results from the database.");
            }
            Date processStart = Calendar.getInstance().getTime();
            BitstreamDispatcher dispatcher = null;
            if (line.hasOption('l')) {
                dispatcher = new SimpleDispatcher(context, processStart, false);
            } else if (line.hasOption('L')) {
                dispatcher = new SimpleDispatcher(context, processStart, true);
            } else if (line.hasOption('b')) {
                String[] ids = line.getOptionValues('b');
                ArrayList<Bitstream> bitstreams = new ArrayList<Bitstream>(ids.length);
                for (int i = 0; i < ids.length; ++i) {
                    try {
                        bitstreams.add(bitstreamService.find(context, UUID.fromString(ids[i])));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("The following argument: " + ids[i] + " is not an integer");
                        System.exit(0);
                    }
                }
                dispatcher = new IteratorDispatcher(bitstreams.iterator());
            } else if (line.hasOption('a')) {
                dispatcher = new HandleDispatcher(context, line.getOptionValue('a'));
            } else if (line.hasOption('d')) {
                try {
                    dispatcher = new LimitedDurationDispatcher(new SimpleDispatcher(context, processStart, true), new Date(System.currentTimeMillis() + Utils.parseDuration(line.getOptionValue('d'))));
                }
                catch (Exception e) {
                    LOG.fatal("Couldn't parse " + line.getOptionValue('d') + " as a duration: ", (Throwable)e);
                    System.exit(0);
                }
            } else if (line.hasOption('c')) {
                int count = Integer.valueOf(line.getOptionValue('c'));
                dispatcher = new LimitedCountDispatcher(new SimpleDispatcher(context, processStart, false), count);
            } else {
                dispatcher = new LimitedCountDispatcher(new SimpleDispatcher(context, processStart, false), 1);
            }
            ResultsLogger logger = new ResultsLogger(processStart);
            CheckerCommand checker = new CheckerCommand(context);
            if (line.hasOption('v')) {
                checker.setReportVerbose(true);
            }
            checker.setProcessStartDate(processStart);
            checker.setDispatcher(dispatcher);
            checker.setCollector(logger);
            checker.process();
            context.complete();
            context = null;
        }
        finally {
            if (context != null) {
                context.abort();
            }
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter myhelp = new HelpFormatter();
        myhelp.printHelp("Checksum Checker\n", options);
        System.out.println("\nSpecify a duration for checker process, using s(seconds),m(minutes), or h(hours): ChecksumChecker -d 30s OR ChecksumChecker -d 30m OR ChecksumChecker -d 2h");
        System.out.println("\nSpecify bitstream IDs: ChecksumChecker -b 13 15 17 20");
        System.out.println("\nLoop once through all bitstreams: ChecksumChecker -l");
        System.out.println("\nLoop continuously through all bitstreams: ChecksumChecker -L");
        System.out.println("\nCheck a defined number of bitstreams: ChecksumChecker -c 10");
        System.out.println("\nReport all processing (verbose)(default reports only errors): ChecksumChecker -v");
        System.out.println("\nDefault (no arguments) is equivalent to '-c 1'");
        System.exit(0);
    }
}

