/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.scripts.handler.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.core.Context;
import org.dspace.scripts.handler.DSpaceRunnableHandler;

public class CommandLineDSpaceRunnableHandler
implements DSpaceRunnableHandler {
    private static final Logger log = LogManager.getLogger(CommandLineDSpaceRunnableHandler.class);

    @Override
    public void start() {
        System.out.println("The script has started");
    }

    @Override
    public void handleCompletion() {
        System.out.println("The script has completed");
    }

    @Override
    public void handleException(Exception e) {
        this.handleException(null, e);
    }

    @Override
    public void handleException(String message) {
        this.handleException(message, null);
    }

    @Override
    public void handleException(String message, Exception e) {
        if (message != null) {
            System.err.println(message);
            log.error(message);
        }
        if (e != null) {
            e.printStackTrace();
            log.error(e.getMessage(), (Throwable)e);
        }
        System.exit(1);
    }

    @Override
    public void logDebug(String message) {
        log.debug(message);
    }

    @Override
    public void logInfo(String message) {
        System.out.println(message);
        log.info(message);
    }

    @Override
    public void logWarning(String message) {
        System.out.println(message);
        log.warn(message);
    }

    @Override
    public void logError(String message) {
        System.err.println(message);
        log.error(message);
    }

    @Override
    public void logError(String message, Throwable throwable) {
        System.err.println(message);
        log.error(message, throwable);
    }

    @Override
    public void printHelp(Options options, String name) {
        if (options != null) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(name, options);
        }
    }

    @Override
    public Optional<InputStream> getFileStream(Context context, String fileName) throws IOException {
        File file = new File(fileName);
        if (!file.exists() || !file.isFile()) {
            return Optional.empty();
        }
        return Optional.of(FileUtils.openInputStream((File)file));
    }

    @Override
    public void writeFilestream(Context context, String fileName, InputStream inputStream, String type) throws IOException {
        File file = new File(fileName);
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
    }

    @Override
    public List<UUID> getSpecialGroups() {
        return Collections.emptyList();
    }
}

