/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import com.google.common.collect.AbstractIterator;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.apache.commons.collections.CollectionUtils;
import org.dspace.core.Context;
import org.dspace.core.GenericDAO;
import org.hibernate.Session;

public abstract class AbstractHibernateDAO<T>
implements GenericDAO<T> {
    protected AbstractHibernateDAO() {
    }

    @Override
    public T create(Context context, T t) throws SQLException {
        this.getHibernateSession(context).persist(t);
        return t;
    }

    @Override
    public void save(Context context, T t) throws SQLException {
    }

    protected Session getHibernateSession(Context context) throws SQLException {
        return (Session)context.getDBConnection().getSession();
    }

    @Override
    public void delete(Context context, T t) throws SQLException {
        this.getHibernateSession(context).delete(t);
    }

    @Override
    public List<T> findAll(Context context, Class<T> clazz) throws SQLException {
        return this.findAll(context, clazz, -1, -1);
    }

    @Override
    public List<T> findAll(Context context, Class<T> clazz, Integer limit, Integer offset) throws SQLException {
        CriteriaQuery<T> criteriaQuery = this.getCriteriaQuery(this.getCriteriaBuilder(context), clazz);
        Root root = criteriaQuery.from(clazz);
        criteriaQuery.select((Selection)root);
        return this.executeCriteriaQuery(context, criteriaQuery, false, limit, offset);
    }

    @Override
    public T findUnique(Context context, String query) throws SQLException {
        Object result = this.createQuery(context, query).getSingleResult();
        return (T)result;
    }

    @Override
    public T findByID(Context context, Class clazz, UUID id) throws SQLException {
        if (id == null) {
            return null;
        }
        Object result = this.getHibernateSession(context).get(clazz, (Serializable)id);
        return (T)result;
    }

    @Override
    public T findByID(Context context, Class clazz, int id) throws SQLException {
        Object result = this.getHibernateSession(context).get(clazz, (Serializable)Integer.valueOf(id));
        return (T)result;
    }

    @Override
    public List<T> findMany(Context context, String query) throws SQLException {
        List result = this.createQuery(context, query).getResultList();
        return result;
    }

    public List<T> findMany(Context context, Query query) throws SQLException {
        List result = query.getResultList();
        return result;
    }

    public Query createQuery(Context context, String query) throws SQLException {
        return this.getHibernateSession(context).createQuery(query);
    }

    public List<T> list(Context context, CriteriaQuery<T> criteriaQuery, boolean cacheable, Class<T> clazz, int maxResults, int offset) throws SQLException {
        criteriaQuery.distinct(true);
        return this.executeCriteriaQuery(context, criteriaQuery, cacheable, maxResults, offset);
    }

    public List<T> list(Context context, CriteriaQuery<T> criteriaQuery, boolean cacheable, Class<T> clazz, int maxResults, int offset, boolean distinct) throws SQLException {
        criteriaQuery.distinct(distinct);
        return this.executeCriteriaQuery(context, criteriaQuery, cacheable, maxResults, offset);
    }

    public List<T> list(Query query) {
        List result = query.getResultList();
        return result;
    }

    public List<T> list(Query query, int limit, int offset) {
        query.setFirstResult(offset);
        query.setMaxResults(limit);
        List result = query.getResultList();
        return result;
    }

    public T uniqueResult(Context context, CriteriaQuery criteriaQuery, boolean cacheable, Class<T> clazz) throws SQLException {
        List<T> list = this.list(context, criteriaQuery, cacheable, clazz, -1, -1);
        if (CollectionUtils.isNotEmpty(list)) {
            if (list.size() == 1) {
                return list.get(0);
            }
            throw new IllegalArgumentException("More than one result found");
        }
        return null;
    }

    public T singleResult(Context context, CriteriaQuery criteriaQuery) throws SQLException {
        org.hibernate.query.Query query = this.getHibernateSession(context).createQuery(criteriaQuery);
        return this.singleResult((Query)query);
    }

    public T singleResult(Query query) {
        query.setMaxResults(1);
        List<T> list = this.list(query);
        if (CollectionUtils.isNotEmpty(list)) {
            return list.get(0);
        }
        return null;
    }

    public T uniqueResult(Query query) {
        Object result = query.getSingleResult();
        return (T)result;
    }

    public Iterator<T> iterate(Query query) {
        org.hibernate.query.Query hquery = (org.hibernate.query.Query)query.unwrap(org.hibernate.query.Query.class);
        final Stream stream = hquery.stream();
        final Iterator iter = stream.iterator();
        return new AbstractIterator<T>(){

            protected T computeNext() {
                return iter.hasNext() ? iter.next() : this.endOfData();
            }

            public void finalize() {
                stream.close();
            }
        };
    }

    public int count(Context context, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder, Root<T> root) throws SQLException {
        return Math.toIntExact(this.countLong(context, criteriaQuery, criteriaBuilder, root));
    }

    public int count(Query query) {
        return ((Long)query.getSingleResult()).intValue();
    }

    public long countLong(Context context, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder, Root<T> root) throws SQLException {
        Expression countExpression = criteriaBuilder.countDistinct(root);
        criteriaQuery.select((Selection)countExpression);
        return (Long)this.getHibernateSession(context).createQuery(criteriaQuery).getSingleResult();
    }

    public CriteriaQuery<T> getCriteriaQuery(CriteriaBuilder criteriaBuilder, Class<T> clazz) {
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(clazz);
        return criteriaQuery;
    }

    public CriteriaBuilder getCriteriaBuilder(Context context) throws SQLException {
        return this.getHibernateSession(context).getCriteriaBuilder();
    }

    public List<T> executeCriteriaQuery(Context context, CriteriaQuery<T> criteriaQuery, boolean cacheable, int maxResults, int offset) throws SQLException {
        org.hibernate.query.Query query = this.getHibernateSession(context).createQuery(criteriaQuery);
        query.setHint("org.hibernate.cacheable", (Object)cacheable);
        if (maxResults != -1) {
            query.setMaxResults(maxResults);
        }
        if (offset != -1) {
            query.setFirstResult(offset);
        }
        return query.getResultList();
    }

    public List<T> findByX(Context context, Class clazz, Map<String, Object> equals, boolean cacheable, int maxResults, int offset) throws SQLException {
        CriteriaBuilder criteriaBuilder = this.getCriteriaBuilder(context);
        CriteriaQuery<T> criteria = this.getCriteriaQuery(criteriaBuilder, clazz);
        Root root = criteria.from(clazz);
        criteria.select((Selection)root);
        for (Map.Entry<String, Object> entry : equals.entrySet()) {
            criteria.where((Expression)criteriaBuilder.equal((Expression)root.get(entry.getKey()), entry.getValue()));
        }
        criteria.orderBy(new Order[]{criteriaBuilder.asc((Expression)root.get("id"))});
        return this.executeCriteriaQuery(context, criteria, cacheable, maxResults, offset);
    }

    public Query createQuery(Context context, CriteriaQuery criteriaQuery) throws SQLException {
        return this.getHibernateSession(context).createQuery(criteriaQuery);
    }
}

