/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.dao.WorkspaceItemDAO;
import org.dspace.content.logic.Filter;
import org.dspace.content.logic.FilterUtils;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.Context;
import org.dspace.core.LogHelper;
import org.dspace.eperson.EPerson;
import org.dspace.event.Event;
import org.dspace.identifier.DOI;
import org.dspace.identifier.DOIIdentifierProvider;
import org.dspace.identifier.Identifier;
import org.dspace.identifier.IdentifierException;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowService;
import org.springframework.beans.factory.annotation.Autowired;

public class WorkspaceItemServiceImpl
implements WorkspaceItemService {
    private static final Logger log = LogManager.getLogger(WorkspaceItemServiceImpl.class);
    @Autowired(required=true)
    protected WorkspaceItemDAO workspaceItemDAO;
    @Autowired(required=true)
    protected AuthorizeService authorizeService;
    @Autowired(required=true)
    protected CollectionService collectionService;
    @Autowired(required=true)
    protected ItemService itemService;
    @Autowired(required=true)
    protected WorkflowService workflowService;
    @Autowired(required=true)
    protected DOIService doiService;

    protected WorkspaceItemServiceImpl() {
    }

    @Override
    public WorkspaceItem find(Context context, int id) throws SQLException {
        WorkspaceItem workspaceItem = (WorkspaceItem)this.workspaceItemDAO.findByID(context, WorkspaceItem.class, id);
        if (workspaceItem == null) {
            if (log.isDebugEnabled()) {
                log.debug(LogHelper.getHeader(context, "find_workspace_item", "not_found,workspace_item_id=" + id));
            }
        } else if (log.isDebugEnabled()) {
            log.debug(LogHelper.getHeader(context, "find_workspace_item", "workspace_item_id=" + id));
        }
        return workspaceItem;
    }

    @Override
    public WorkspaceItem create(Context context, Collection collection, boolean template) throws AuthorizeException, SQLException {
        return this.create(context, collection, null, template, false);
    }

    @Override
    public WorkspaceItem create(Context context, Collection collection, boolean template, boolean isNewVersion) throws AuthorizeException, SQLException {
        return this.create(context, collection, null, template, isNewVersion);
    }

    @Override
    public WorkspaceItem create(Context context, Collection collection, UUID uuid, boolean template, boolean isNewVersion) throws AuthorizeException, SQLException {
        this.authorizeService.authorizeAction(context, collection, 3);
        WorkspaceItem workspaceItem = this.workspaceItemDAO.create(context, new WorkspaceItem());
        workspaceItem.setCollection(collection);
        Item item = uuid != null ? this.itemService.create(context, workspaceItem, uuid) : this.itemService.create(context, workspaceItem);
        item.setSubmitter(context.getCurrentUser());
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 0, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 1, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 3, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 4, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.authorizeService.addPolicy(context, (DSpaceObject)item, 2, item.getSubmitter(), ResourcePolicy.TYPE_SUBMISSION);
        this.itemService.populateWithTemplateItemMetadata(context, collection, template, item);
        this.itemService.update(context, item);
        if (DSpaceServicesFactory.getInstance().getConfigurationService().getBooleanProperty("identifiers.submission.register", false) && !isNewVersion) {
            try {
                Map<Class<? extends Identifier>, Filter> filters = FilterUtils.getIdentifierFilters(true);
                IdentifierServiceFactory.getInstance().getIdentifierService().register(context, (DSpaceObject)item, filters);
                DOI doi = this.doiService.findDOIByDSpaceObject(context, item);
                if (doi != null) {
                    doi.setStatus(DOIIdentifierProvider.PENDING);
                    this.doiService.update(context, doi);
                }
            }
            catch (IdentifierException e) {
                log.error("Could not register identifier(s) for item {}: {}", (Object)item.getID(), (Object)e.getMessage());
            }
        }
        workspaceItem.setItem(item);
        log.info(LogHelper.getHeader(context, "create_workspace_item", "workspace_item_id=" + workspaceItem.getID() + "item_id=" + item.getID() + "collection_id=" + collection.getID()));
        context.addEvent(new Event(2, 2, item.getID(), null, this.itemService.getIdentifiers(context, item)));
        return workspaceItem;
    }

    @Override
    public WorkspaceItem create(Context c, WorkflowItem workflowItem) throws SQLException, AuthorizeException {
        WorkspaceItem potentialDuplicate = this.findByItem(c, workflowItem.getItem());
        if (potentialDuplicate != null) {
            throw new IllegalArgumentException(String.format("A workspace item referring to item %s already exists (%d)", workflowItem.getItem().getID(), potentialDuplicate.getID()));
        }
        WorkspaceItem workspaceItem = this.workspaceItemDAO.create(c, new WorkspaceItem());
        workspaceItem.setItem(workflowItem.getItem());
        workspaceItem.setCollection(workflowItem.getCollection());
        this.update(c, workspaceItem);
        return workspaceItem;
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep) throws SQLException {
        return this.workspaceItemDAO.findByEPerson(context, ep);
    }

    @Override
    public List<WorkspaceItem> findByEPerson(Context context, EPerson ep, Integer limit, Integer offset) throws SQLException {
        return this.workspaceItemDAO.findByEPerson(context, ep, limit, offset);
    }

    @Override
    public List<WorkspaceItem> findByCollection(Context context, Collection collection) throws SQLException {
        return this.workspaceItemDAO.findByCollection(context, collection);
    }

    @Override
    public WorkspaceItem findByItem(Context context, Item item) throws SQLException {
        return this.workspaceItemDAO.findByItem(context, item);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context) throws SQLException {
        return this.workspaceItemDAO.findAll(context);
    }

    @Override
    public List<WorkspaceItem> findAll(Context context, Integer limit, Integer offset) throws SQLException {
        return this.workspaceItemDAO.findAll(context, limit, offset);
    }

    @Override
    public void update(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
        log.info(LogHelper.getHeader(context, "update_workspace_item", "workspace_item_id=" + workspaceItem.getID()));
        this.itemService.update(context, workspaceItem.getItem());
        this.workspaceItemDAO.save(context, workspaceItem);
    }

    @Override
    public void deleteAll(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException, IOException {
        Item item = workspaceItem.getItem();
        if (!(this.authorizeService.isAdmin(context) || item.getSubmitter() != null && context.getCurrentUser() != null && context.getCurrentUser().getID() == item.getSubmitter().getID())) {
            throw new AuthorizeException("Must be an administrator or the original submitter to delete a workspace item");
        }
        log.info(LogHelper.getHeader(context, "delete_workspace_item", "workspace_item_id=" + workspaceItem.getID() + "item_id=" + item.getID() + "collection_id=" + workspaceItem.getCollection().getID()));
        this.workspaceItemDAO.delete(context, workspaceItem);
        this.itemService.delete(context, item);
    }

    @Override
    public int countTotal(Context context) throws SQLException {
        return this.workspaceItemDAO.countRows(context);
    }

    @Override
    public int countByEPerson(Context context, EPerson ep) throws SQLException {
        return this.workspaceItemDAO.countRows(context, ep);
    }

    @Override
    public List<Map.Entry<Integer, Long>> getStageReachedCounts(Context context) throws SQLException {
        return this.workspaceItemDAO.getStageReachedCounts(context);
    }

    @Override
    public void deleteWrapper(Context context, WorkspaceItem workspaceItem) throws SQLException, AuthorizeException {
        Item item = workspaceItem.getItem();
        this.authorizeService.authorizeAction(context, item, 1);
        log.info(LogHelper.getHeader(context, "delete_workspace_item", "workspace_item_id=" + workspaceItem.getID() + "item_id=" + item.getID() + "collection_id=" + workspaceItem.getCollection().getID()));
        this.workspaceItemDAO.delete(context, workspaceItem);
    }

    @Override
    public void move(Context context, WorkspaceItem source, Collection fromCollection, Collection toCollection) throws DCInputsReaderException {
        source.setCollection(toCollection);
        ArrayList<MetadataValue> remove = new ArrayList<MetadataValue>();
        List<String> diff = Util.differenceInSubmissionFields(fromCollection, toCollection);
        for (String toRemove : diff) {
            for (MetadataValue value : source.getItem().getMetadata()) {
                if (!value.getMetadataField().toString('.').equals(toRemove)) continue;
                remove.add(value);
            }
        }
        source.getItem().removeMetadata(remove);
    }
}

