/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.importer.external.crossref;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.util.XMLUtils;
import org.dspace.importer.external.metadatamapping.contributor.JsonPathMetadataProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CrossRefAbstractProcessor
implements JsonPathMetadataProcessor {
    private static final Logger log = LogManager.getLogger();
    private String path;

    @Override
    public Collection<String> processMetadata(String json) {
        String abstractValue;
        JsonNode rootNode = this.convertStringJsonToJsonNode(json);
        JsonNode abstractNode = rootNode.at(this.path);
        ArrayList<String> values = new ArrayList<String>();
        if (!abstractNode.isMissingNode() && StringUtils.isNotEmpty((CharSequence)(abstractValue = abstractNode.textValue())) && (abstractValue = this.prettifyAbstract(abstractValue)) != null) {
            values.add(abstractValue);
        }
        return values;
    }

    private String prettifyAbstract(String abstractValue) {
        Document xmlDoc;
        if (!abstractValue.contains("<jats:")) {
            return abstractValue;
        }
        String xmlString = "<root>" + abstractValue + "</root>";
        try {
            DocumentBuilder builder = XMLUtils.getDocumentBuilder();
            InputSource is = new InputSource(new StringReader(xmlString));
            xmlDoc = builder.parse(is);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            log.warn("unable to parse XML markup in CrossRef abstract field: " + e.getMessage());
            return null;
        }
        StringBuilder sb = new StringBuilder();
        NodeList rootElements = xmlDoc.getElementsByTagName("root");
        Node rootElement = rootElements.item(0);
        NodeList childElements = rootElement.getChildNodes();
        for (int i = 0; i < childElements.getLength(); ++i) {
            Node childElement = childElements.item(i);
            String nodeName = childElement.getNodeName();
            if (StringUtils.equals((CharSequence)nodeName, (CharSequence)"jats:title")) {
                if (StringUtils.equals((CharSequence)childElement.getTextContent(), (CharSequence)"Abstract")) continue;
                sb.append(childElement.getTextContent());
                sb.append("\n");
                continue;
            }
            if (!StringUtils.equals((CharSequence)nodeName, (CharSequence)"jats:sec")) continue;
            NodeList secElements = childElement.getChildNodes();
            for (int j = 0; j < secElements.getLength(); ++j) {
                Node secChildElement = secElements.item(j);
                sb.append(secChildElement.getTextContent());
                sb.append("\n");
            }
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    private JsonNode convertStringJsonToJsonNode(String json) {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode body = null;
        try {
            body = mapper.readTree(json);
        }
        catch (JsonProcessingException e) {
            log.error("Unable to process json response.", (Throwable)e);
        }
        return body;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

