/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.OutputStream;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.StreamDisseminationCrosswalk;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.handle.factory.HandleServiceFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SubscriptionDsoMetadataForEmailCompose
implements StreamDisseminationCrosswalk {
    private List<String> metadata = new ArrayList<String>();
    @Autowired
    private ItemService itemService;

    @Override
    public boolean canDisseminate(Context context, DSpaceObject dso) {
        return Objects.nonNull(dso) && dso.getType() == 2;
    }

    @Override
    public void disseminate(Context context, DSpaceObject dso, OutputStream out) throws SQLException {
        if (dso.getType() == 2) {
            Item item = (Item)dso;
            PrintStream printStream = new PrintStream(out);
            for (String actualMetadata : this.metadata) {
                String[] splitted = actualMetadata.split("\\.");
                String qualifier = null;
                if (splitted.length == 3) {
                    qualifier = splitted[2];
                }
                String metadataValue = this.itemService.getMetadataFirstValue(item, splitted[0], splitted[1], qualifier, "*");
                printStream.print(metadataValue + " ");
            }
            String itemURL = HandleServiceFactory.getInstance().getHandleService().resolveToURL(context, item.getHandle());
            printStream.print(itemURL);
            printStream.print("\n");
            printStream.close();
        }
    }

    @Override
    public String getMIMEType() {
        return "text/plain";
    }

    public List<String> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<String> metadata) {
        this.metadata = metadata;
    }
}

