/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.iiif;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dspace.app.client.DSpaceHttpClientFactory;
import org.dspace.content.Bitstream;
import org.dspace.iiif.IIIFApiQueryService;
import org.dspace.iiif.canvasdimension.Util;
import org.dspace.iiif.util.IIIFSharedUtils;

public class IIIFApiQueryServiceImpl
implements IIIFApiQueryService {
    private static final Logger log = LogManager.getLogger(IIIFApiQueryServiceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getImageDimensions(Bitstream bitstream) {
        int[] arr = new int[2];
        String path = IIIFSharedUtils.getInfoJsonPath(bitstream);
        BufferedReader in = null;
        try (CloseableHttpClient httpClient = DSpaceHttpClientFactory.getInstance().build();){
            String inputLine;
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)new HttpGet(path));
            in = new BufferedReader(new InputStreamReader(httpResponse.getEntity().getContent()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            JsonNode parent = new ObjectMapper().readTree(response.toString());
            if (parent.has("width") && parent.has("height")) {
                arr[0] = parent.get("width").asInt();
                arr[1] = parent.get("height").asInt();
                int[] nArray = Util.checkDimensions(arr);
                return nArray;
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return null;
    }
}

