/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.google.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dspace.google.GoogleAnalyticsEvent;
import org.dspace.google.client.GoogleAnalyticsClientException;
import org.dspace.google.client.GoogleAnalyticsClientRequestBuilder;
import org.dspace.services.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;

public class GoogleAnalytics4ClientRequestBuilder
implements GoogleAnalyticsClientRequestBuilder {
    private final String endpointUrl;
    @Autowired
    private ConfigurationService configurationService;
    private ObjectMapper objectMapper = new ObjectMapper();

    public GoogleAnalytics4ClientRequestBuilder(String endpointUrl) {
        this.endpointUrl = endpointUrl;
    }

    @Override
    public String getEndpointUrl(String analyticsKey) {
        if (!StringUtils.startsWith((String)analyticsKey, (String)"G-")) {
            throw new IllegalArgumentException("Only keys with G- prefix are supported");
        }
        String apiSecret = this.configurationService.getProperty("google.analytics.api-secret");
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)apiSecret)) {
            throw new GoogleAnalyticsClientException("The API secret must be configured to sent GA4 events");
        }
        return this.endpointUrl + "?api_secret=" + apiSecret + "&measurement_id=" + analyticsKey;
    }

    @Override
    public List<String> composeRequestsBody(String analyticsKey, List<GoogleAnalyticsEvent> events) {
        Map<String, List<GoogleAnalyticsEvent>> eventsGroupedByClientId = this.groupByClientId(events);
        ArrayList<String> requestsBody = new ArrayList<String>();
        for (String clientId : eventsGroupedByClientId.keySet()) {
            String requestBody = this.composeRequestBody(clientId, eventsGroupedByClientId.get(clientId));
            requestsBody.add(requestBody);
        }
        return requestsBody;
    }

    private Map<String, List<GoogleAnalyticsEvent>> groupByClientId(List<GoogleAnalyticsEvent> events) {
        return events.stream().collect(Collectors.groupingBy(GoogleAnalyticsEvent::getClientId));
    }

    private String composeRequestBody(String clientId, List<GoogleAnalyticsEvent> events) {
        GoogleAnalytics4EventsVO eventsVo = new GoogleAnalytics4EventsVO(clientId);
        events.stream().map(GoogleAnalytics4EventVO::fromGoogleAnalyticsEvent).forEach(eventsVo::addEvent);
        return this.toJsonAsString(eventsVo);
    }

    private String toJsonAsString(GoogleAnalytics4EventsVO eventsVo) {
        try {
            return this.objectMapper.writeValueAsString((Object)eventsVo);
        }
        catch (JsonProcessingException e) {
            throw new GoogleAnalyticsClientException(e);
        }
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public static class GoogleAnalytics4EventsVO {
        @JsonProperty(value="client_id")
        private final String clientId;
        private final List<GoogleAnalytics4EventVO> events;

        public GoogleAnalytics4EventsVO(String clientId) {
            this.clientId = clientId;
            this.events = new ArrayList<GoogleAnalytics4EventVO>();
        }

        public String getClientId() {
            return this.clientId;
        }

        public List<GoogleAnalytics4EventVO> getEvents() {
            return this.events;
        }

        public void addEvent(GoogleAnalytics4EventVO event) {
            this.events.add(event);
        }
    }

    public static class GoogleAnalytics4EventParamsVO {
        private final String action = "download";
        private final String category = "bitstream";
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private final long time;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="document_title")
        private final String documentTitle;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="document_path")
        private final String documentPath;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="document_referrer")
        private final String documentReferrer;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="user_agent")
        private final String userAgent;
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonProperty(value="user_ip")
        private final String userIp;

        public GoogleAnalytics4EventParamsVO(long time, String documentTitle, String documentPath, String documentReferrer, String userAgent, String userIp) {
            this.time = time;
            this.documentTitle = documentTitle;
            this.documentPath = documentPath;
            this.documentReferrer = documentReferrer;
            this.userAgent = userAgent;
            this.userIp = userIp;
        }

        public long getTime() {
            return this.time;
        }

        public String getDocumentTitle() {
            return this.documentTitle;
        }

        public String getDocumentPath() {
            return this.documentPath;
        }

        public String getDocumentReferrer() {
            return this.documentReferrer;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getUserIp() {
            return this.userIp;
        }

        public String getAction() {
            return "download";
        }

        public String getCategory() {
            return "bitstream";
        }
    }

    public static class GoogleAnalytics4EventVO {
        private final String name = "item";
        private final GoogleAnalytics4EventParamsVO params;

        public static GoogleAnalytics4EventVO fromGoogleAnalyticsEvent(GoogleAnalyticsEvent event) {
            return new GoogleAnalytics4EventVO(event.getTime(), event.getDocumentTitle(), event.getDocumentPath(), event.getDocumentReferrer(), event.getUserAgent(), event.getUserIp());
        }

        public GoogleAnalytics4EventVO(long time, String documentTitle, String documentPath, String documentReferrer, String userAgent, String userIp) {
            this.params = new GoogleAnalytics4EventParamsVO(time, documentTitle, documentPath, documentReferrer, userAgent, userIp);
        }

        public String getName() {
            return "item";
        }

        public GoogleAnalytics4EventParamsVO getParams() {
            return this.params;
        }
    }
}

