/*
 * Decompiled with CFR 0.152.
 */
package org.drools.impl.adapters;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.drools.core.builder.conf.impl.JaxbConfigurationImpl;
import org.drools.core.builder.conf.impl.ResourceConfigurationImpl;
import org.kie.api.io.ResourceConfiguration;
import org.kie.internal.builder.JaxbConfiguration;

public class JaxbConfigurationAdapter
extends ResourceConfigurationImpl
implements JaxbConfiguration {
    private static final long serialVersionUID = -1425447385459529502L;
    private final org.drools.builder.JaxbConfiguration delegate;

    public JaxbConfigurationAdapter(org.drools.builder.JaxbConfiguration delegate) {
        this.delegate = delegate;
    }

    public Options getXjcOpts() {
        return this.delegate.getXjcOpts();
    }

    public String getSystemId() {
        return this.delegate.getSystemId();
    }

    public List<String> getClasses() {
        return this.delegate.getClasses();
    }

    public Properties toProperties() {
        Properties prop = super.toProperties();
        prop.setProperty("drools.jaxb.conf.systemId", this.getSystemId());
        prop.setProperty("drools.jaxb.conf.classes", ((Object)((Object)this)).getClass().toString());
        Options xjcOpts = this.getXjcOpts();
        if (xjcOpts != null) {
            prop.setProperty("drools.jaxb.conf.opts.class", xjcOpts.getClass().getName());
            if (xjcOpts.getSchemaLanguage() != null) {
                prop.setProperty("drools.jaxb.conf.opts.lang", xjcOpts.getSchemaLanguage().toString());
            }
        }
        return prop;
    }

    public ResourceConfiguration fromProperties(Properties prop) {
        super.fromProperties(prop);
        ((JaxbConfigurationImpl)this.delegate).setSystemId(prop.getProperty("drools.jaxb.conf.systemId", null));
        String classesStr = prop.getProperty("drools.jaxb.conf.classes", "[]");
        classesStr = classesStr.substring(1, classesStr.length() - 1).trim();
        ArrayList<String> classes = new ArrayList<String>();
        if (classesStr != null && classesStr.length() > 1) {
            for (String clz : classesStr.split(",")) {
                classes.add(clz.trim());
            }
        }
        ((JaxbConfigurationImpl)this.delegate).setClasses(classes);
        String optsClass = prop.getProperty("drools.jaxb.conf.opts.class", null);
        if (optsClass != null) {
            try {
                Options xjcOpts = (Options)Class.forName(optsClass).newInstance();
                String optsLang = prop.getProperty("drools.jaxb.conf.opts.lang", null);
                if (optsLang != null) {
                    xjcOpts.setSchemaLanguage(Language.valueOf((String)optsLang));
                }
                ((JaxbConfigurationImpl)this.delegate).setXjcOpts(xjcOpts);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JaxbConfigurationAdapter && this.delegate.equals(((JaxbConfigurationAdapter)((Object)obj)).delegate);
    }
}

