/*
 * Decompiled with CFR 0.152.
 */
package org.drools.logger;

import org.drools.event.KnowledgeRuntimeEventManager;
import org.drools.logger.KnowledgeRuntimeLogger;
import org.drools.logger.KnowledgeRuntimeLoggerFactoryService;

public class KnowledgeRuntimeLoggerFactory {
    private static KnowledgeRuntimeLoggerFactoryService knowledgeRuntimeLoggerFactoryService;

    public static KnowledgeRuntimeLogger newFileLogger(KnowledgeRuntimeEventManager session, String fileName) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newFileLogger(session, fileName);
    }

    public static KnowledgeRuntimeLogger newThreadedFileLogger(KnowledgeRuntimeEventManager session, String fileName, int interval) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newThreadedFileLogger(session, fileName, interval);
    }

    public static KnowledgeRuntimeLogger newConsoleLogger(KnowledgeRuntimeEventManager session) {
        return KnowledgeRuntimeLoggerFactory.getKnowledgeRuntimeLoggerProvider().newConsoleLogger(session);
    }

    private static synchronized void setKnowledgeRuntimeLoggerProvider(KnowledgeRuntimeLoggerFactoryService provider) {
        knowledgeRuntimeLoggerFactoryService = provider;
    }

    private static synchronized KnowledgeRuntimeLoggerFactoryService getKnowledgeRuntimeLoggerProvider() {
        if (knowledgeRuntimeLoggerFactoryService == null) {
            KnowledgeRuntimeLoggerFactory.loadProvider();
        }
        return knowledgeRuntimeLoggerFactoryService;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.impl.KnowledgeRuntimeLoggerFactoryServiceImpl");
            KnowledgeRuntimeLoggerFactory.setKnowledgeRuntimeLoggerProvider((KnowledgeRuntimeLoggerFactoryService)cls.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Provider org.drools.impl.KnowledgeRuntimeLoggerFactoryServiceImpl could not be set.", e);
        }
    }
}

