/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceType
implements Serializable {
    private String name;
    private String description;
    private String defaultExtension;
    private String[] otherExtensions;
    private static final Map<String, ResourceType> CACHE = Collections.synchronizedMap(new HashMap());
    public static final ResourceType DRL = ResourceType.addResourceTypeToRegistry("DRL", "Drools Rule Language", "drl", new String[0]);
    public static final ResourceType XDRL = ResourceType.addResourceTypeToRegistry("XDRL", "Drools XML Rule Language", "xdrl", new String[0]);
    public static final ResourceType DSL = ResourceType.addResourceTypeToRegistry("DSL", "Drools DSL", "dsl", new String[0]);
    public static final ResourceType DSLR = ResourceType.addResourceTypeToRegistry("DSLR", "Drools DSL Rule", "dslr", new String[0]);
    public static final ResourceType DRF = ResourceType.addResourceTypeToRegistry("DRF", "Drools Rule Flow Language", "rf", new String[0]);
    public static final ResourceType BPMN2 = ResourceType.addResourceTypeToRegistry("BPMN2", "jBPM BPMN2 Language", "bpmn", "bpmn2");
    public static final ResourceType DTABLE = ResourceType.addResourceTypeToRegistry("DTABLE", "Decision Table", "xls", new String[0]);
    public static final ResourceType PKG = ResourceType.addResourceTypeToRegistry("PKG", "Binary Package", "pkg", new String[0]);
    public static final ResourceType BRL = ResourceType.addResourceTypeToRegistry("BRL", "Drools Business Rule Language", "brl", new String[0]);
    public static final ResourceType CHANGE_SET = ResourceType.addResourceTypeToRegistry("CHANGE_SET", "Change Set", "xcs", new String[0]);
    public static final ResourceType XSD = ResourceType.addResourceTypeToRegistry("XSD", "XSD", "xsd", new String[0]);
    public static final ResourceType PMML = ResourceType.addResourceTypeToRegistry("PMML", "Predictive Model Markup Language", "pmml", new String[0]);
    public static final ResourceType DESCR = ResourceType.addResourceTypeToRegistry("DESCR", "Knowledge Descriptor", "descr", new String[0]);

    public ResourceType(String name, String description, String defaultExtension, String ... otherExtensions) {
        this.name = name;
        this.description = description;
        this.defaultExtension = defaultExtension;
        this.otherExtensions = otherExtensions;
    }

    public static ResourceType addResourceTypeToRegistry(String resourceType, String description, String defaultExtension, String ... otherExtensions) {
        ResourceType resource = new ResourceType(resourceType, description, defaultExtension, otherExtensions);
        CACHE.put(resourceType, resource);
        return resource;
    }

    public static ResourceType getResourceType(String resourceType) {
        ResourceType resource = CACHE.get(resourceType);
        if (resource == null) {
            throw new RuntimeException("Unable to determine resource type " + resourceType);
        }
        return resource;
    }

    public static ResourceType determineResourceType(String resourceName) {
        for (ResourceType type : CACHE.values()) {
            if (!type.matchesExtension(resourceName)) continue;
            return type;
        }
        return null;
    }

    public boolean matchesExtension(String resourceName) {
        if (resourceName != null) {
            if (resourceName.endsWith("." + this.defaultExtension)) {
                return true;
            }
            for (String extension : this.otherExtensions) {
                if (!resourceName.endsWith("." + extension)) continue;
                return true;
            }
        }
        return false;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ResourceType = '" + this.description + "'";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return this.name.equals(other.name);
    }
}

