/*
 * Decompiled with CFR 0.152.
 */
package org.drools.example.api.kiemodulemodel;

import java.io.File;
import java.io.PrintStream;
import org.drools.core.util.Drools;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.io.Resource;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KieModuleModelExample {
    private static final Logger LOG = LoggerFactory.getLogger(KieModuleModelExample.class);

    public void go(PrintStream out) {
        KieServices ks = KieServices.Factory.get();
        KieFileSystem kfs = ks.newKieFileSystem();
        Resource ex1Res = ks.getResources().newFileSystemResource(KieModuleModelExample.getFile("named-kiesession"));
        Resource ex2Res = ks.getResources().newFileSystemResource(KieModuleModelExample.getFile("kiebase-inclusion"));
        ReleaseId rid = ks.newReleaseId("org.drools", "kiemodulemodel-example", Drools.getFullVersion());
        kfs.generateAndWritePomXML(rid);
        KieModuleModel kModuleModel = ks.newKieModuleModel();
        kModuleModel.newKieBaseModel("kiemodulemodel").addInclude("kbase1").addInclude("kbase2").newKieSessionModel("ksession6");
        kfs.writeKModuleXML(kModuleModel.toXML());
        kfs.write("src/main/resources/kiemodulemodel/HAL6.drl", KieModuleModelExample.getRule());
        KieBuilder kb = ks.newKieBuilder(kfs);
        kb.setDependencies(new Resource[]{ex1Res, ex2Res});
        kb.buildAll();
        if (kb.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException("Build Errors:\n" + kb.getResults().toString());
        }
        KieContainer kContainer = ks.newKieContainer(rid);
        KieSession kSession = kContainer.newKieSession("ksession6");
        kSession.setGlobal("out", (Object)out);
        Object msg1 = KieModuleModelExample.createMessage(kContainer, "Dave", "Hello, HAL. Do you read me, HAL?");
        kSession.insert(msg1);
        kSession.fireAllRules();
        Object msg2 = KieModuleModelExample.createMessage(kContainer, "Dave", "Open the pod bay doors, HAL.");
        kSession.insert(msg2);
        kSession.fireAllRules();
        Object msg3 = KieModuleModelExample.createMessage(kContainer, "Dave", "What's the problem?");
        kSession.insert(msg3);
        kSession.fireAllRules();
    }

    public static void main(String[] args) {
        new KieModuleModelExample().go(System.out);
    }

    private static String getRule() {
        String s = "package org.drools.example.api.kiemodulemodel \n\nimport org.drools.example.api.namedkiesession.Message \n\nrule rule6 when \n    Message(text == \"What's the problem?\") \nthen\n    insert( new Message(\"HAL\", \"I think you know what the problem is just as well as I do.\" ) ); \nend \n";
        return s;
    }

    private static Object createMessage(KieContainer kContainer, String name, String text) {
        Object o = null;
        try {
            Class<?> cl = kContainer.getClassLoader().loadClass("org.drools.example.api.namedkiesession.Message");
            o = cl.getConstructor(String.class, String.class).newInstance(name, text);
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
        }
        return o;
    }

    public static File getFile(String exampleName) {
        File exampleFolder = null;
        for (File folder = new File("drools-examples-api").getAbsoluteFile(); folder != null && !(exampleFolder = new File(folder, exampleName)).exists(); folder = folder.getParentFile()) {
            exampleFolder = null;
        }
        if (exampleFolder != null) {
            File targetFolder = new File(exampleFolder, "target");
            if (!targetFolder.exists()) {
                throw new RuntimeException("The target folder does not exist, please build project " + exampleName + " first");
            }
            for (String str : targetFolder.list()) {
                if (!str.startsWith(exampleName) || str.endsWith("-sources.jar") || str.endsWith("-tests.jar") || str.endsWith("-javadoc.jar")) continue;
                return new File(targetFolder, str);
            }
        }
        throw new RuntimeException("The target jar does not exist, please build project " + exampleName + " first");
    }
}

