/*
 * Decompiled with CFR 0.152.
 */
package org.drools.verifier.visitor;

import java.util.List;
import java.util.Map;
import org.drools.lang.descr.BaseDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.lang.descr.TypeFieldDescr;
import org.drools.verifier.components.Field;
import org.drools.verifier.components.Import;
import org.drools.verifier.components.ObjectType;
import org.drools.verifier.data.VerifierData;
import org.drools.verifier.visitor.ObjectTypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDeclarationDescrVisitor {
    private final VerifierData data;

    public TypeDeclarationDescrVisitor(VerifierData data) {
        this.data = data;
    }

    public void visit(List<TypeDeclarationDescr> typeDeclarationDescrs) {
        for (TypeDeclarationDescr typeDeclaration : typeDeclarationDescrs) {
            Import objectImport = this.data.getImportByName(typeDeclaration.getTypeName());
            String objectTypeName = objectImport == null ? typeDeclaration.getTypeName() : objectImport.getName();
            ObjectType objectType = this.data.getObjectTypeByFullName(objectTypeName);
            if (objectType == null) {
                objectType = new ObjectType((BaseDescr)typeDeclaration);
                objectType.setName(typeDeclaration.getTypeName());
                objectType.setFullName(typeDeclaration.getTypeName());
                this.data.add(objectType);
            }
            for (String fieldName : typeDeclaration.getFields().keySet()) {
                Field field = this.data.getFieldByObjectTypeAndFieldName(objectType.getFullName(), fieldName);
                if (field != null) continue;
                field = ObjectTypeFactory.createField((BaseDescr)typeDeclaration.getFields().get(fieldName), fieldName, objectType);
                field.setFieldType(((TypeFieldDescr)typeDeclaration.getFields().get(fieldName)).getPattern().getObjectType());
                this.data.add(field);
            }
            for (String metadata : typeDeclaration.getAnnotations().keySet()) {
                Map values = typeDeclaration.getAnnotation(metadata).getValueMap();
                for (String value : values.keySet()) {
                    objectType.getMetadata().put((Object)metadata, (Object)value);
                }
            }
        }
    }
}

